/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.gui;

import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import cpw.mods.fml.common.Optional;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import tconstruct.TConstruct;
import tconstruct.library.client.StencilGuiElement;
import tconstruct.library.client.TConstructClientRegistry;
import tconstruct.library.crafting.StencilBuilder;
import tconstruct.tools.gui.GuiButtonStencil;
import tconstruct.tools.inventory.PatternShaperContainer;
import tconstruct.tools.logic.StencilTableLogic;
import tconstruct.util.network.PatternTablePacket;

@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public class StencilTableGui
extends GuiContainer
implements INEIGuiHandler {
    StencilTableLogic logic;
    int activeButton;
    private static final ResourceLocation background = new ResourceLocation("tinker", "textures/gui/patternshaper.png");

    public StencilTableGui(InventoryPlayer inventoryplayer, StencilTableLogic shaper, World world, int x, int y, int z) {
        super((Container)new PatternShaperContainer(inventoryplayer, shaper));
        this.logic = shaper;
        this.activeButton = 0;
    }

    public void onGuiClosed() {
        super.onGuiClosed();
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"crafters.PatternShaper"), 50, 6, 0x404040);
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"container.inventory"), 8, this.ySize - 96 + 2, 0x404040);
    }

    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(background);
        int cornerX = (this.width - this.xSize) / 2;
        int cornerY = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(cornerX, cornerY, 0, 0, this.xSize, this.ySize);
        if (!this.logic.isStackInSlot(0)) {
            this.drawTexturedModalRect(cornerX + 47, cornerY + 34, 176, 0, 18, 18);
        }
    }

    public void initGui() {
        ItemStack stack;
        GuiButtonStencil button;
        StencilGuiElement element;
        int iter;
        super.initGui();
        int bpr = 4;
        int cornerX = this.guiLeft - 22 * bpr;
        int cornerY = this.guiTop + 2;
        this.buttonList.clear();
        int id = 0;
        for (iter = 0; iter < TConstructClientRegistry.stencilButtons.size(); ++iter) {
            element = TConstructClientRegistry.stencilButtons.get(iter);
            if (element.stencilIndex == -1) continue;
            button = new GuiButtonStencil(id++, cornerX + 22 * (iter % bpr), cornerY + 22 * (iter / bpr), element.buttonIconX, element.buttonIconY, element.domain, element.texture, element);
            this.buttonList.add(button);
        }
        cornerX = this.guiLeft + this.xSize + 4;
        for (iter = 0; iter < TConstructClientRegistry.stencilButtons2.size(); ++iter) {
            element = TConstructClientRegistry.stencilButtons2.get(iter);
            if (element.stencilIndex == -1) continue;
            button = new GuiButtonStencil(id++, cornerX + 22 * (iter % bpr), cornerY + 22 * (iter / bpr), element.buttonIconX, element.buttonIconY, element.domain, element.texture, element);
            this.buttonList.add(button);
        }
        if (this.logic.getStackInSlot(1) != null) {
            this.activeButton = StencilBuilder.getId(this.logic.getStackInSlot(1));
            this.setActiveButton(this.activeButton);
            stack = StencilBuilder.getStencil(((GuiButtonStencil)((Object)this.buttonList.get((int)this.activeButton))).element.stencilIndex);
        } else {
            stack = null;
        }
        this.logic.setSelectedPattern(stack);
        this.updateServer(stack);
    }

    protected void actionPerformed(GuiButton button) {
        int id;
        ItemStack stack;
        ItemStack pattern = this.logic.getStackInSlot(0);
        if (pattern != null && StencilBuilder.isBlank(pattern) && (stack = StencilBuilder.getStencil(id = ((GuiButtonStencil)button).element.stencilIndex)) != null) {
            this.logic.setSelectedPattern(stack);
            this.updateServer(stack);
        }
        this.setActiveButton(button.id);
    }

    private void setActiveButton(int id) {
        ((GuiButton)this.buttonList.get((int)this.activeButton)).enabled = true;
        this.activeButton = id;
        ((GuiButton)this.buttonList.get((int)this.activeButton)).enabled = false;
    }

    void updateServer(ItemStack stack) {
        TConstruct.packetPipeline.sendToServer(new PatternTablePacket(this.logic.xCoord, this.logic.yCoord, this.logic.zCoord, stack));
    }

    public VisiblityData modifyVisiblity(GuiContainer guiContainer, VisiblityData visiblityData) {
        return visiblityData;
    }

    public Iterable<Integer> getItemSpawnSlots(GuiContainer guiContainer, ItemStack itemStack) {
        return null;
    }

    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer guiContainer) {
        return Collections.emptyList();
    }

    public boolean handleDragNDrop(GuiContainer guiContainer, int i, int i2, ItemStack itemStack, int i3) {
        return false;
    }

    public boolean hideItemPanelSlot(GuiContainer guiContainer, int x, int y, int w, int h) {
        return x > this.guiLeft + this.xSize + 4 && x < this.guiLeft + this.xSize + 4 + 66 + 16 && y > this.guiTop - 10 && y < this.guiTop + 2 + 22 * (TConstructClientRegistry.stencilButtons2.size() - 1) / 4 + 22 * (TConstructClientRegistry.stencilButtons2.size() % 4 > 0 ? 1 : 0);
    }
}

