/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.gui;

import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import cpw.mods.fml.common.Optional;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.HarvestLevels;
import tconstruct.smeltery.inventory.ActiveContainer;
import tconstruct.tools.inventory.PartCrafterChestContainer;
import tconstruct.tools.logic.PartBuilderLogic;

@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public class PartCrafterGui
extends GuiContainer
implements INEIGuiHandler {
    PartBuilderLogic logic;
    String title;
    String otherTitle = "";
    boolean drawChestPart;
    boolean hasTop;
    boolean hasBottom;
    ItemStack topMaterial;
    ItemStack bottomMaterial;
    ToolMaterial topEnum;
    ToolMaterial bottomEnum;
    private static final int CRAFT_WIDTH = 176;
    private static final int CRAFT_HEIGHT = 166;
    private static final int DESC_WIDTH = 126;
    private static final int DESC_HEIGHT = 166;
    private static final int CHEST_WIDTH = 122;
    private static final int CHEST_HEIGHT = 114;
    private int craftingLeft = 0;
    private int craftingTop = 0;
    private int craftingTextLeft = 0;
    private int descLeft = 0;
    private int descTop = 0;
    private int descTextLeft = 0;
    private int chestLeft = 0;
    private int chestTop = 0;
    private static final ResourceLocation background = new ResourceLocation("tinker", "textures/gui/toolparts.png");
    private static final ResourceLocation minichest = new ResourceLocation("tinker", "textures/gui/patternchestmini.png");
    private static final ResourceLocation description = new ResourceLocation("tinker", "textures/gui/description.png");

    public PartCrafterGui(InventoryPlayer inventoryplayer, PartBuilderLogic partlogic, World world, int x, int y, int z) {
        super((Container)((ActiveContainer)partlogic.getGuiContainer(inventoryplayer, world, x, y, z)));
        this.logic = partlogic;
        this.drawChestPart = this.inventorySlots instanceof PartCrafterChestContainer;
        this.title = "\u00a7n" + StatCollector.translateToLocal((String)"gui.partcrafter1");
    }

    public void initGui() {
        super.initGui();
        this.xSize = 176;
        this.ySize = 166;
        this.craftingLeft = (this.width - 176) / 2;
        this.craftingTop = (this.height - 166) / 2;
        this.guiLeft = this.craftingLeft;
        this.guiTop = this.craftingTop;
        this.descLeft = this.craftingLeft + 176;
        this.descTop = this.craftingTop;
        if (this.drawChestPart) {
            this.xSize += 116;
            this.guiLeft -= 116;
            this.chestLeft = this.guiLeft;
            this.chestTop = this.guiTop + 11;
        }
        this.craftingTextLeft = this.craftingLeft - this.guiLeft;
        this.descTextLeft = this.descLeft - this.guiLeft;
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        if (this.drawChestPart) {
            this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"inventory.PatternChest"), 14, 17, 0x404040);
        }
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"crafters.PartBuilder"), this.craftingTextLeft + 6, 6, 0x404040);
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"container.inventory"), this.craftingTextLeft + 8, this.ySize - 96 + 2, 0x404040);
        this.drawMaterialInformation();
    }

    void drawDefaultInformation() {
        this.title = "\u00a7n" + StatCollector.translateToLocal((String)"gui.partcrafter2");
        this.drawCenteredString(this.fontRendererObj, this.title, this.descTextLeft + 63, 8, 0xFFFFFF);
        this.fontRendererObj.drawSplitString(StatCollector.translateToLocal((String)"gui.partcrafter3"), this.descTextLeft + 8, 24, 115, 0xFFFFFF);
    }

    void drawMaterialInformation() {
        String heart;
        int attack;
        ItemStack top = this.logic.getStackInSlot(2);
        ItemStack bottom = this.logic.getStackInSlot(3);
        if (this.topMaterial != top) {
            this.topMaterial = top;
            int topID = PatternBuilder.instance.getPartID(top);
            if (topID != Short.MAX_VALUE) {
                this.topEnum = TConstructRegistry.getMaterial(topID);
                this.hasTop = true;
                this.title = "\u00a7n" + this.topEnum.localizedName();
            } else {
                this.hasTop = false;
            }
        }
        if (this.bottomMaterial != bottom) {
            this.bottomMaterial = bottom;
            int bottomID = PatternBuilder.instance.getPartID(bottom);
            if (bottomID != Short.MAX_VALUE) {
                this.bottomEnum = TConstructRegistry.getMaterial(bottomID);
                this.hasBottom = true;
                this.otherTitle = "\u00a7n" + this.bottomEnum.localizedName();
            } else {
                this.hasBottom = false;
            }
        }
        int offset = 8;
        if (this.hasTop) {
            this.drawCenteredString(this.fontRendererObj, this.title, this.descTextLeft + 63, offset, 0xFFFFFF);
            this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"gui.partcrafter4") + this.topEnum.durability(), this.descTextLeft + 8, offset + 16, 0xFFFFFF);
            this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"gui.partcrafter5") + this.topEnum.handleDurability() + "x", this.descTextLeft + 8, offset + 27, 0xFFFFFF);
            this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"gui.partcrafter6") + (float)this.topEnum.toolSpeed() / 100.0f, this.descTextLeft + 8, offset + 38, 0xFFFFFF);
            this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"gui.partcrafter7") + HarvestLevels.getHarvestLevelName(this.topEnum.harvestLevel()), this.descTextLeft + 8, offset + 49, 0xFFFFFF);
            attack = this.topEnum.attack();
            String string = heart = attack == 2 ? StatCollector.translateToLocal((String)"gui.partcrafter8") : StatCollector.translateToLocal((String)"gui.partcrafter9");
            if (attack % 2 == 0) {
                this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"gui.partcrafter10") + attack / 2 + heart, this.descTextLeft + 8, offset + 60, 0xFFFFFF);
            } else {
                this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"gui.partcrafter10") + (float)attack / 2.0f + heart, this.descTextLeft + 8, offset + 60, 0xFFFFFF);
            }
        }
        offset = 90;
        if (this.hasBottom) {
            this.drawCenteredString(this.fontRendererObj, this.otherTitle, this.descTextLeft + 63, offset, 0xFFFFFF);
            this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"gui.partcrafter4") + this.bottomEnum.durability(), this.descTextLeft + 8, offset + 16, 0xFFFFFF);
            this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"gui.partcrafter5") + this.bottomEnum.handleDurability() + "x", this.descTextLeft + 8, offset + 27, 0xFFFFFF);
            this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"gui.partcrafter6") + (float)this.bottomEnum.toolSpeed() / 100.0f, this.descTextLeft + 8, offset + 38, 0xFFFFFF);
            this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"gui.partcrafter7") + HarvestLevels.getHarvestLevelName(this.bottomEnum.harvestLevel()), this.descTextLeft + 8, offset + 49, 0xFFFFFF);
            attack = this.bottomEnum.attack();
            String string = heart = attack == 2 ? StatCollector.translateToLocal((String)"gui.partcrafter8") : StatCollector.translateToLocal((String)"gui.partcrafter9");
            if (attack % 2 == 0) {
                this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"gui.partcrafter10") + attack / 2 + heart, this.descTextLeft + 8, offset + 60, 0xFFFFFF);
            } else {
                this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"gui.partcrafter10") + (float)attack / 2.0f + heart, this.descTextLeft + 8, offset + 60, 0xFFFFFF);
            }
        }
        if (!this.hasTop && !this.hasBottom) {
            this.drawDefaultInformation();
        }
    }

    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(background);
        this.drawTexturedModalRect(this.craftingLeft, this.craftingTop, 0, 0, 176, 166);
        this.drawTexturedModalRect(this.craftingLeft + 39, this.craftingTop + 26, 0, 166, 98, 36);
        if (!this.logic.isStackInSlot(0)) {
            this.drawTexturedModalRect(this.craftingLeft + 39, this.craftingTop + 26, 176, 0, 18, 18);
        }
        if (!this.logic.isStackInSlot(2)) {
            this.drawTexturedModalRect(this.craftingLeft + 57, this.craftingTop + 26, 176, 18, 18, 18);
        }
        if (!this.logic.isStackInSlot(1)) {
            this.drawTexturedModalRect(this.craftingLeft + 39, this.craftingTop + 44, 176, 0, 18, 18);
        }
        if (!this.logic.isStackInSlot(3)) {
            this.drawTexturedModalRect(this.craftingLeft + 57, this.craftingTop + 44, 176, 36, 18, 18);
        }
        if (this.drawChestPart) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.getTextureManager().bindTexture(minichest);
            this.drawTexturedModalRect(this.chestLeft, this.chestTop, 0, 0, 122, 114);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(description);
        this.drawTexturedModalRect(this.descLeft, this.descTop, 126, 0, 126, 166);
    }

    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        currentVisibility.showWidgets = this.width - this.xSize >= 107;
        if (this.guiLeft < 58) {
            currentVisibility.showStateButtons = false;
        }
        return currentVisibility;
    }

    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return null;
    }

    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return Collections.emptyList();
    }

    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        return false;
    }

    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        if (y + h - 4 < this.guiTop || y + 4 > this.guiTop + this.ySize) {
            return false;
        }
        return x + 4 <= this.guiLeft + this.xSize + 126;
    }
}

