/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import tconstruct.tools.inventory.FurnaceContainer;
import tconstruct.tools.logic.FurnaceLogic;

@SideOnly(value=Side.CLIENT)
public class FurnaceGui
extends GuiContainer {
    private static final ResourceLocation furnaceGuiTextures = new ResourceLocation("textures/gui/container/furnace.png");
    private FurnaceLogic logic;

    public FurnaceGui(InventoryPlayer inventory, FurnaceLogic furnace) {
        super((Container)new FurnaceContainer(inventory, furnace));
        this.logic = furnace;
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        String s = this.logic.isInvNameLocalized() ? this.logic.getInvName() : I18n.format((String)this.logic.getInvName(), (Object[])new Object[0]);
        this.fontRendererObj.drawString(s, this.xSize / 2 - this.fontRendererObj.getStringWidth(s) / 2, 6, 0x404040);
        this.fontRendererObj.drawString(I18n.format((String)"container.inventory", (Object[])new Object[0]), 8, this.ySize - 96 + 2, 0x404040);
    }

    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        int i1;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(furnaceGuiTextures);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(k, l, 0, 0, this.xSize, this.ySize);
        if (this.logic.isBurning()) {
            i1 = this.logic.gaugeFuelScaled(12);
            this.drawTexturedModalRect(k + 56, l + 36 + 12 - i1, 176, 12 - i1, 14, i1 + 2);
        }
        i1 = this.logic.gaugeProgressScaled(24);
        this.drawTexturedModalRect(k + 79, l + 34, 176, 14, i1 + 1, 16);
    }
}

