/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import tconstruct.TConstruct;
import tconstruct.library.TConstructRegistry;
import tconstruct.tools.logic.BattlesignLogic;
import tconstruct.util.network.SignDataPacket;

public class BattlesignGui
extends GuiScreen {
    private BattlesignLogic battlesign;
    private float bgColR = 1.0f;
    private float bgColG = 1.0f;
    private float bgColB = 1.0f;
    private static ResourceLocation background = new ResourceLocation("tinker:textures/gui/battlesignText.png");
    private String[] text = new String[]{"", "", "", "", ""};
    int currentLine = 0;

    public BattlesignGui(BattlesignLogic logic) {
        NBTTagCompound tag;
        this.battlesign = logic;
        ItemStack stack = logic.getEquipmentItem();
        if (stack != null && (tag = stack.getTagCompound().getCompoundTag("InfiTool")) != null) {
            int head = tag.getInteger("Head");
            int bgCol = TConstructRegistry.getMaterial(head).primaryColor();
            this.bgColR = (float)(bgCol >> 16 & 0xFF) / 255.0f;
            this.bgColG = (float)(bgCol >> 8 & 0xFF) / 255.0f;
            this.bgColB = (float)(bgCol & 0xFF) / 255.0f;
        }
    }

    public void initGui() {
        this.buttonList.clear();
        super.initGui();
        Keyboard.enableRepeatEvents((boolean)true);
        int k = (this.width - 100) / 2;
        int l = (this.height - 110) / 2;
        this.buttonList.add(new GuiButton(0, k, l + 100, 100, 20, "Done"));
    }

    public void drawScreen(int mouseX, int mouseY, float something) {
        Tessellator t = Tessellator.instance;
        GL11.glColor4f((float)this.bgColR, (float)this.bgColG, (float)this.bgColB, (float)1.0f);
        this.mc.getTextureManager().bindTexture(background);
        int k = (this.width - 100) / 2;
        int l = (this.height - 103) / 2;
        this.drawTexturedModalRect(k, l, 0, 0, 100, 103);
        super.drawScreen(mouseX, mouseY, something);
        GL11.glPushMatrix();
        float lum = this.calcLuminance(this.bgColR, this.bgColG, this.bgColB);
        for (int i = 0; i < this.text.length; ++i) {
            this.fontRendererObj.drawString((lum >= 35.0f ? EnumChatFormatting.BLACK : (lum >= 31.0f ? EnumChatFormatting.GRAY : EnumChatFormatting.WHITE)) + (i == this.currentLine ? "> " : "") + this.text[i] + (i == this.currentLine ? " \u00a7r" + (lum >= 35.0f ? EnumChatFormatting.BLACK : (lum >= 31.0f ? EnumChatFormatting.GRAY : EnumChatFormatting.WHITE)) + "<" : ""), k - this.fontRendererObj.getStringWidth((i == this.currentLine ? "> " : "") + this.text[i] + (i == this.currentLine ? " <" : "")) / 2 + 51, l + 4 + 10 * i, 0);
        }
        GL11.glPopMatrix();
    }

    protected void keyTyped(char c, int i) {
        super.keyTyped(c, i);
        if (this.fontRendererObj.getStringWidth(this.text[this.currentLine]) < 90 && ChatAllowedCharacters.isAllowedCharacter((char)c)) {
            if (Keyboard.isKeyDown((int)56) && c == 'f' && (this.text[this.currentLine].length() == 0 || this.text[this.currentLine].charAt(this.text[this.currentLine].length() - 1) != '\u00a7')) {
                int n = this.currentLine;
                this.text[n] = this.text[n] + "\u00a7";
            } else {
                int n = this.currentLine;
                this.text[n] = this.text[n] + c;
            }
        } else {
            switch (i) {
                case 14: {
                    if (this.text[this.currentLine].length() <= 0) break;
                    this.text[this.currentLine] = this.text[this.currentLine].substring(0, this.text[this.currentLine].length() - 1);
                    break;
                }
                case 28: {
                    this.moveLine(1);
                    break;
                }
                case 200: {
                    this.moveLine(-1);
                    break;
                }
                case 208: {
                    this.moveLine(1);
                }
            }
        }
    }

    private void moveLine(int i) {
        this.currentLine = i < 0 ? (this.currentLine <= 0 ? this.text.length - 1 : --this.currentLine) : (this.currentLine >= this.text.length - 1 ? 0 : ++this.currentLine);
    }

    public void onGuiClosed() {
        super.onGuiClosed();
        Keyboard.enableRepeatEvents((boolean)false);
        TConstruct.packetPipeline.sendToServer(new SignDataPacket(this.battlesign.getWorldObj().provider.dimensionId, this.battlesign.xCoord, this.battlesign.yCoord, this.battlesign.zCoord, this.text));
    }

    private float calcLuminance(float r, float g, float b) {
        return (r * 255.0f * 0.299f + g * 255.0f * 0.587f + b * 255.0f * 0.114f) / 3.0f;
    }

    protected void actionPerformed(GuiButton button) {
        if (button.id == 0) {
            this.mc.displayGuiScreen((GuiScreen)null);
            this.mc.setIngameFocus();
        }
    }
}

