/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.entity;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import tconstruct.library.entity.ProjectileBase;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.ToolCore;

public class DaggerEntity
extends ProjectileBase {
    public int roll;

    public DaggerEntity(World world) {
        super(world);
    }

    public DaggerEntity(World world, double d, double d1, double d2) {
        super(world, d, d1, d2);
    }

    public DaggerEntity(World world, EntityPlayer player, float speed, float accuracy, ItemStack stack) {
        super(world, player, speed, accuracy, stack);
        float pitch = Math.max(-90.0f, player.rotationPitch - 20.0f);
        this.setLocationAndAngles(player.posX, player.posY + (double)player.getEyeHeight(), player.posZ, player.rotationYaw, pitch);
        this.posX -= (double)(MathHelper.cos((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.posY -= (double)0.1f;
        this.posZ -= (double)(MathHelper.sin((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.yOffset = 0.0f;
        this.motionX = -MathHelper.sin((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.motionZ = MathHelper.cos((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.motionY = -MathHelper.sin((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.setThrowableHeading(this.motionX, this.motionY, this.motionZ, speed, accuracy);
    }

    @Override
    public void onUpdate() {
        if (this.ticksInGround == 0) {
            this.roll = (this.roll + 20) % 360;
        }
        super.onUpdate();
    }

    @Override
    public void onHitEntity(MovingObjectPosition movingobjectposition) {
        AbilityHelper.onLeftClickEntity(this.returnStack, (EntityLivingBase)((EntityPlayer)this.shootingEntity), movingobjectposition.entityHit, (ToolCore)this.returnStack.getItem());
    }

    @Override
    protected double getGravity() {
        return 0.1;
    }

    @Override
    protected double getSlowdown() {
        return 0.02;
    }
}

