/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mantle.blocks.abstracts.InventoryBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tconstruct.TConstruct;
import tconstruct.library.TConstructRegistry;
import tconstruct.tools.TinkerTools;
import tconstruct.tools.logic.PartBuilderLogic;
import tconstruct.tools.logic.PatternChestLogic;
import tconstruct.tools.logic.StencilTableLogic;
import tconstruct.tools.logic.ToolStationLogic;
import tconstruct.tools.model.TableRender;
import tconstruct.util.config.PHConstruct;

public class ToolStationBlock
extends InventoryBlock {
    public ToolStationBlock(Material material) {
        super(material);
        this.setCreativeTab(TConstructRegistry.blockTab);
        this.setHardness(2.0f);
        this.setStepSound(Block.soundTypeWood);
    }

    public String[] getTextureNames() {
        String[] textureNames = new String[]{"toolstation_top", "toolstation_side", "toolstation_bottom", "partbuilder_oak_top", "partbuilder_oak_side", "partbuilder_oak_bottom", "partbuilder_spruce_top", "partbuilder_spruce_side", "partbuilder_spruce_bottom", "partbuilder_birch_top", "partbuilder_birch_side", "partbuilder_birch_bottom", "partbuilder_jungle_top", "partbuilder_jungle_side", "partbuilder_jungle_bottom", "patternchest_top", "patternchest_side", "patternchest_bottom", "stenciltable_oak_top", "stenciltable_oak_side", "stenciltable_oak_bottom", "stenciltable_spruce_top", "stenciltable_spruce_side", "stenciltable_spruce_bottom", "stenciltable_birch_top", "stenciltable_birch_side", "stenciltable_birch_bottom", "stenciltable_jungle_top", "stenciltable_jungle_side", "stenciltable_jungle_bottom"};
        return textureNames;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (meta <= 4) {
            return this.icons[meta * 3 + this.getTextureIndex(side)];
        }
        if (meta <= 9) {
            return this.icons[15 + this.getTextureIndex(side)];
        }
        return this.icons[meta * 3 + this.getTextureIndex(side) - 12];
    }

    public int getTextureIndex(int side) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 0;
        }
        return 1;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.UP;
    }

    public int getRenderType() {
        return TableRender.model;
    }

    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        int metadata = world.getBlockMetadata(x, y, z);
        if (metadata == 5) {
            return AxisAlignedBB.getBoundingBox((double)((double)x + this.minX), (double)((double)y + this.minY), (double)((double)z + this.minZ), (double)((double)x + this.maxX), (double)((double)y + this.maxY - 0.125), (double)((double)z + this.maxZ));
        }
        return AxisAlignedBB.getBoundingBox((double)((double)x + this.minX), (double)((double)y + this.minY), (double)((double)z + this.minZ), (double)((double)x + this.maxX), (double)((double)y + this.maxY), (double)((double)z + this.maxZ));
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new ToolStationLogic();
            }
            case 1: {
                return new PartBuilderLogic();
            }
            case 2: {
                return new PartBuilderLogic();
            }
            case 3: {
                return new PartBuilderLogic();
            }
            case 4: {
                return new PartBuilderLogic();
            }
            case 5: {
                return new PatternChestLogic();
            }
            case 6: {
                return new PatternChestLogic();
            }
            case 7: {
                return new PatternChestLogic();
            }
            case 8: {
                return new PatternChestLogic();
            }
            case 9: {
                return new PatternChestLogic();
            }
            case 10: {
                return new StencilTableLogic();
            }
            case 11: {
                return new StencilTableLogic();
            }
            case 12: {
                return new StencilTableLogic();
            }
            case 13: {
                return new StencilTableLogic();
            }
        }
        return null;
    }

    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        int md = world.getBlockMetadata(x, y, z);
        if (md == 0) {
            return 0;
        }
        if (md < 5) {
            return 1;
        }
        if (md < 10) {
            return 2;
        }
        return 3;
    }

    public Object getModInstance() {
        return TConstruct.instance;
    }

    public void getSubBlocks(Item id, CreativeTabs tab, List list) {
        int iter;
        for (iter = 0; iter < 6; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
        for (iter = 10; iter < 14; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    public String getTextureDomain(int textureNameIndex) {
        return "tinker";
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        int meta;
        player.addExhaustion(0.025f);
        if (!world.isRemote && world.getGameRules().getGameRuleBooleanValue("doTileDrops") && (meta = world.getBlockMetadata(x, y, z)) >= 5 && meta <= 9) {
            ItemStack chest = new ItemStack((Block)this, 1, 5);
            NBTTagCompound inventory = new NBTTagCompound();
            PatternChestLogic logic = (PatternChestLogic)world.getTileEntity(x, y, z);
            logic.writeInventoryToNBT(inventory);
            NBTTagCompound baseTag = new NBTTagCompound();
            baseTag.setTag("Inventory", (NBTBase)inventory);
            chest.setTagCompound(baseTag);
            for (int i = 0; i < logic.getSizeInventory(); ++i) {
                logic.setInventorySlotContents(i, null);
            }
            if (!player.capabilities.isCreativeMode || player.isSneaking()) {
                float f = 0.7f;
                double d0 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, chest);
                entityitem.delayBeforeCanPickup = 10;
                world.spawnEntityInWorld((Entity)entityitem);
            }
        }
        return world.setBlockToAir(x, y, z);
    }

    public void harvestBlock(World world, EntityPlayer player, int x, int y, int z, int meta) {
        if (meta < 5 || meta > 9) {
            super.harvestBlock(world, player, x, y, z, meta);
        }
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        int meta;
        boolean keptInventory = false;
        if (stack.hasTagCompound()) {
            NBTTagCompound inventory = stack.getTagCompound().getCompoundTag("Inventory");
            TileEntity te = world.getTileEntity(x, y, z);
            if (inventory != null && te instanceof PatternChestLogic) {
                PatternChestLogic logic = (PatternChestLogic)te;
                logic.readInventoryFromNBT(inventory);
                logic.xCoord = x;
                logic.yCoord = y;
                logic.zCoord = z;
                keptInventory = true;
            }
        }
        if (!keptInventory && PHConstruct.freePatterns && (meta = world.getBlockMetadata(x, y, z)) == 5) {
            PatternChestLogic logic = (PatternChestLogic)world.getTileEntity(x, y, z);
            for (int i = 1; i <= 13; ++i) {
                logic.setInventorySlotContents(i - 1, new ItemStack(TinkerTools.woodPattern, 1, i));
            }
            logic.setInventorySlotContents(13, new ItemStack(TinkerTools.woodPattern, 1, 22));
        }
        super.onBlockPlacedBy(world, x, y, z, living, stack);
    }
}

