/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.logic;

import mantle.blocks.abstracts.MultiServantLogic;
import mantle.blocks.iface.IFacingLogic;
import mantle.world.CoordTuple;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import tconstruct.smeltery.logic.SmelteryLogic;

public class SmelteryDrainLogic
extends MultiServantLogic
implements IFluidHandler,
IFacingLogic {
    byte direction;

    public boolean canUpdate() {
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.hasValidMaster() && resource != null && this.canFill(from, resource.getFluid())) {
            SmelteryLogic smeltery = (SmelteryLogic)this.worldObj.getTileEntity(this.getMasterPosition().x, this.getMasterPosition().y, this.getMasterPosition().z);
            return smeltery.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.hasValidMaster() && this.canDrain(from, null)) {
            SmelteryLogic smeltery = (SmelteryLogic)this.worldObj.getTileEntity(this.getMasterPosition().x, this.getMasterPosition().y, this.getMasterPosition().z);
            return smeltery.drain(maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.hasValidMaster() && this.canDrain(from, resource.getFluid())) {
            SmelteryLogic smeltery = (SmelteryLogic)this.worldObj.getTileEntity(this.getMasterPosition().x, this.getMasterPosition().y, this.getMasterPosition().z);
            if (resource.getFluid() == smeltery.getFluid().getFluid()) {
                return smeltery.drain(resource.amount, doDrain);
            }
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        boolean containsFluid;
        if (!this.hasValidMaster()) {
            return false;
        }
        boolean bl = containsFluid = fluid == null;
        if (fluid != null) {
            SmelteryLogic smeltery = (SmelteryLogic)this.worldObj.getTileEntity(this.getMasterPosition().x, this.getMasterPosition().y, this.getMasterPosition().z);
            for (FluidStack fstack : smeltery.moltenMetal) {
                if (fstack.getFluidID() != fluid.getID()) continue;
                containsFluid = true;
                break;
            }
        }
        return containsFluid;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.hasValidMaster() && (from == this.getForgeDirection() || from == this.getForgeDirection().getOpposite() || from == ForgeDirection.UNKNOWN)) {
            SmelteryLogic smeltery = (SmelteryLogic)this.worldObj.getTileEntity(this.getMasterPosition().x, this.getMasterPosition().y, this.getMasterPosition().z);
            return smeltery.getMultiTankInfo();
        }
        return null;
    }

    public byte getRenderDirection() {
        return this.direction;
    }

    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    public void setDirection(int side) {
    }

    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        if (pitch > 45.0f) {
            this.direction = 1;
        } else if (pitch < -45.0f) {
            this.direction = 0;
        } else {
            int facing = MathHelper.floor_double((double)((double)(yaw / 360.0f) + 0.5)) & 3;
            switch (facing) {
                case 0: {
                    this.direction = (byte)2;
                    break;
                }
                case 1: {
                    this.direction = (byte)5;
                    break;
                }
                case 2: {
                    this.direction = (byte)3;
                    break;
                }
                case 3: {
                    this.direction = (byte)4;
                }
            }
        }
    }

    public void readFromNBT(NBTTagCompound tags) {
        super.readFromNBT(tags);
        this.direction = tags.getByte("Direction");
    }

    public void writeToNBT(NBTTagCompound tags) {
        super.writeToNBT(tags);
        tags.setByte("Direction", this.direction);
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readFromNBT(packet.func_148857_g());
        this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
    }

    public int comparatorStrength() {
        CoordTuple master = this.getMasterPosition();
        if (master == null) {
            return 0;
        }
        SmelteryLogic smeltery = (SmelteryLogic)this.worldObj.getTileEntity(master.x, master.y, master.z);
        if (smeltery == null) {
            return 0;
        }
        if (smeltery.maxLiquid == 0) {
            return 0;
        }
        return 15 * smeltery.currentLiquid / smeltery.maxLiquid;
    }
}

