/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.logic;

import mantle.blocks.iface.IActiveLogic;
import mantle.blocks.iface.IFacingLogic;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class FaucetLogic
extends TileEntity
implements IFacingLogic,
IActiveLogic,
IFluidHandler {
    byte direction;
    boolean active;
    public FluidStack liquid;
    public boolean hasRedstonePower = false;

    public boolean activateFaucet() {
        if (this.liquid == null && this.active) {
            FluidStack templiquid;
            int x = this.xCoord;
            int z = this.zCoord;
            switch (this.getRenderDirection()) {
                case 2: {
                    ++z;
                    break;
                }
                case 3: {
                    --z;
                    break;
                }
                case 4: {
                    ++x;
                    break;
                }
                case 5: {
                    --x;
                }
            }
            TileEntity drainte = this.worldObj.getTileEntity(x, this.yCoord, z);
            TileEntity tankte = this.worldObj.getTileEntity(this.xCoord, this.yCoord - 1, this.zCoord);
            if (drainte != null && drainte instanceof IFluidHandler && tankte != null && tankte instanceof IFluidHandler && (templiquid = ((IFluidHandler)drainte).drain(this.getForgeDirection(), 144, false)) != null) {
                int drained = ((IFluidHandler)tankte).fill(ForgeDirection.UP, templiquid, false);
                if (drained > 0) {
                    this.liquid = ((IFluidHandler)drainte).drain(this.getForgeDirection(), drained, true);
                    ((IFluidHandler)tankte).fill(ForgeDirection.UP, this.liquid, true);
                    this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void updateEntity() {
        if (this.liquid != null) {
            this.liquid.amount -= 6;
            if (this.liquid.amount <= 0) {
                this.liquid = null;
                if (!this.activateFaucet()) {
                    this.active = false;
                    this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                }
            }
        }
    }

    public byte getRenderDirection() {
        return this.direction;
    }

    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    public void setDirection(int side) {
        this.direction = side != 0 && side != 1 ? (byte)side : (byte)2;
    }

    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
    }

    public void readFromNBT(NBTTagCompound tags) {
        super.readFromNBT(tags);
        this.readCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.direction = tags.getByte("Direction");
        this.liquid = tags.getBoolean("hasLiquid") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)tags.getCompoundTag("Fluid")) : null;
    }

    public void writeToNBT(NBTTagCompound tags) {
        super.writeToNBT(tags);
        this.writeCustomNBT(tags);
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.setByte("Direction", this.direction);
        tags.setBoolean("hasLiquid", this.liquid != null);
        if (this.liquid != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.liquid.writeToNBT(nbt);
            tags.setTag("Fluid", (NBTBase)nbt);
        }
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readCustomNBT(packet.func_148857_g());
        this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean flag) {
        if (!this.active) {
            this.active = true;
            if (!this.activateFaucet()) {
                this.active = false;
            }
        } else {
            this.active = false;
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return null;
    }
}

