/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.inventory;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import tconstruct.smeltery.TinkerSmeltery;
import tconstruct.smeltery.inventory.ActiveContainer;
import tconstruct.smeltery.inventory.ActiveSlot;
import tconstruct.smeltery.logic.SmelteryLogic;

public class SmelteryContainer
extends ActiveContainer {
    public SmelteryLogic logic;
    public InventoryPlayer playerInv;
    public int fuel = 0;
    private int slotRow;
    public int columns;
    public final int smelterySize;

    public SmelteryContainer(InventoryPlayer inventoryplayer, SmelteryLogic smeltery) {
        this.logic = smeltery;
        this.playerInv = inventoryplayer;
        this.slotRow = 0;
        this.columns = smeltery.getBlocksPerLayer() >= 16 ? 4 : 3;
        this.smelterySize = smeltery.getBlockCapacity();
        int totalSlots = smeltery.getBlockCapacity();
        int y = 0;
        for (int i = 0; i < totalSlots; ++i) {
            int x = i % this.columns;
            this.addDualSlotToContainer(new ActiveSlot((IInventory)smeltery, x + y * this.columns, 2 + x * 22, 8 + y * 18, y < 8));
            if (x != this.columns - 1) continue;
            ++y;
        }
        int baseX = 90 + (this.columns - 3) * 22;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.addSlotToContainer(new Slot((IInventory)inventoryplayer, column + row * 9 + 9, baseX + column * 18, 84 + row * 18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.addSlotToContainer(new Slot((IInventory)inventoryplayer, column, baseX + column * 18, 142));
        }
    }

    public int updateRows(int invRow) {
        if (invRow != this.slotRow) {
            this.slotRow = invRow;
            int basePos = invRow * this.columns;
            for (int iter = 0; iter < this.activeInventorySlots.size(); ++iter) {
                ActiveSlot slot = (ActiveSlot)((Object)this.activeInventorySlots.get(iter));
                if (slot.activeSlotNumber >= basePos && slot.activeSlotNumber < basePos + this.columns * 8) {
                    slot.setActive(true);
                } else {
                    slot.setActive(false);
                }
                int xPos = (iter - basePos) % this.columns;
                int yPos = (iter - basePos) / this.columns;
                slot.xDisplayPosition = 2 + 22 * xPos;
                slot.yDisplayPosition = 8 + 18 * yPos;
            }
            return this.slotRow;
        }
        return -1;
    }

    public int scrollTo(float scrollPos) {
        int slots = 8 * this.columns;
        float total = (this.logic.getSizeInventory() - slots) / this.columns;
        if ((this.logic.getSizeInventory() - slots) % this.columns != 0) {
            total += 1.0f;
        }
        int rowPos = Math.round(total * scrollPos);
        return this.updateRows(rowPos);
    }

    public void detectAndSendChanges() {
        if (this.smelterySize == this.inventorySlots.size()) {
            super.detectAndSendChanges();
        }
    }

    public void updateProgressBar(int id, int value) {
        if (id == 0) {
            this.logic.fuelGague = value;
        }
    }

    @Override
    public boolean canInteractWith(EntityPlayer entityplayer) {
        Block block = this.logic.getWorldObj().getBlock(this.logic.xCoord, this.logic.yCoord, this.logic.zCoord);
        if (block != TinkerSmeltery.smeltery && block != TinkerSmeltery.smelteryNether) {
            return false;
        }
        return this.logic.isUseableByPlayer(entityplayer);
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slotID) {
        ItemStack stack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotID);
        if (slot != null && slot.getHasStack()) {
            ItemStack slotStack = slot.getStack();
            stack = slotStack.copy();
            if (slotID < this.smelterySize ? !this.mergeItemStack(slotStack, this.logic.getSizeInventory(), this.inventorySlots.size(), true) : !this.mergeItemStack(slotStack, 0, this.smelterySize, false)) {
                return null;
            }
            if (slotStack.stackSize == 0) {
                slot.putStack((ItemStack)null);
            } else {
                slot.onSlotChanged();
            }
        }
        return stack;
    }

    protected boolean mergeItemStack(ItemStack inputStack, int startSlot, int endSlot, boolean flag) {
        ItemStack slotStack;
        Slot slot;
        boolean merged = false;
        int slotPos = startSlot;
        if (flag) {
            slotPos = endSlot - 1;
        }
        if (inputStack.isStackable() && startSlot >= this.logic.getSizeInventory()) {
            while (inputStack.stackSize > 0 && (!flag && slotPos < endSlot || flag && slotPos >= startSlot)) {
                slot = (Slot)this.inventorySlots.get(slotPos);
                slotStack = slot.getStack();
                if (slotStack != null && slotStack.isItemEqual(inputStack) && ItemStack.areItemStackTagsEqual((ItemStack)slotStack, (ItemStack)inputStack)) {
                    int l = slotStack.stackSize + inputStack.stackSize;
                    if (l <= inputStack.getMaxStackSize()) {
                        inputStack.stackSize = 0;
                        slotStack.stackSize = l;
                        slot.onSlotChanged();
                        merged = true;
                    } else if (slotStack.stackSize < inputStack.getMaxStackSize()) {
                        inputStack.stackSize -= inputStack.getMaxStackSize() - slotStack.stackSize;
                        slotStack.stackSize = inputStack.getMaxStackSize();
                        slot.onSlotChanged();
                        merged = true;
                    }
                }
                if (flag) {
                    --slotPos;
                    continue;
                }
                ++slotPos;
            }
        }
        if (inputStack.stackSize > 0) {
            slotPos = flag ? endSlot - 1 : startSlot;
            while (!flag && slotPos < endSlot || flag && slotPos >= startSlot) {
                slot = (Slot)this.inventorySlots.get(slotPos);
                slotStack = slot.getStack();
                if (slotStack == null) {
                    slot.putStack(inputStack.copy());
                    slot.onSlotChanged();
                    --inputStack.stackSize;
                    merged = true;
                    break;
                }
                if (flag) {
                    --slotPos;
                    continue;
                }
                ++slotPos;
            }
        }
        return merged;
    }
}

