/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import tconstruct.library.TConstructRegistry;
import tconstruct.smeltery.TinkerSmeltery;

public class LiquidMetalFinite
extends BlockFluidFinite {
    String texture;
    public IIcon stillIcon;
    public IIcon flowIcon;

    public LiquidMetalFinite(Fluid fluid, String texture) {
        super(fluid, TinkerSmeltery.liquidMetal);
        this.texture = texture;
        this.setCreativeTab(TConstructRegistry.blockTab);
    }

    public int getRenderBlockPass() {
        return 0;
    }

    public void registerBlockIcons(IIconRegister iconRegister) {
        this.stillIcon = iconRegister.registerIcon("tinker:" + this.texture);
        this.flowIcon = iconRegister.registerIcon("tinker:" + this.texture + "_flow");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (side == 0 || side == 1) {
            return this.stillIcon;
        }
        return this.flowIcon;
    }

    public void onEntityCollidedWithBlock(World par1World, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            entity.motionX *= 0.4;
            entity.motionZ *= 0.4;
        }
        if (!(entity instanceof EntityItem) && !entity.isImmuneToFire()) {
            entity.attackEntityFrom(DamageSource.lava, 4.0f);
            entity.setFire(15);
        }
    }
}

