/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mantle.blocks.iface.IServantLogic;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import tconstruct.library.TConstructRegistry;
import tconstruct.smeltery.logic.LavaTankLogic;
import tconstruct.smeltery.model.TankRender;

public class LavaTankBlock
extends BlockContainer {
    public IIcon[] icons;
    String texturePrefix = "";

    public LavaTankBlock() {
        super(Material.rock);
        this.setHardness(3.0f);
        this.setResistance(20.0f);
        this.setCreativeTab(TConstructRegistry.blockTab);
        this.setBlockName("TConstruct.LavaTank");
        this.setStepSound(Block.soundTypeGrass);
    }

    public LavaTankBlock(String prefix) {
        this();
        this.texturePrefix = prefix;
    }

    public String[] getTextureNames() {
        String[] textureNames = new String[]{"lavatank_side", "lavatank_top", "searedgague_top", "searedgague_side", "searedgague_bottom", "searedwindow_top", "searedwindow_side", "searedwindow_bottom"};
        if (!this.texturePrefix.equals("")) {
            for (int i = 0; i < textureNames.length; ++i) {
                textureNames[i] = this.texturePrefix + "_" + textureNames[i];
            }
        }
        return textureNames;
    }

    public void registerBlockIcons(IIconRegister IIconRegister2) {
        String[] textureNames = this.getTextureNames();
        this.icons = new IIcon[textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = IIconRegister2.registerIcon("tinker:" + textureNames[i]);
        }
    }

    public int getRenderBlockPass() {
        return 1;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        Block bID = world.getBlock(x, y, z);
        return bID == this ? false : super.shouldSideBeRendered(world, x, y, z, side);
    }

    public boolean canRenderInPass(int pass) {
        TankRender.renderPass = pass;
        return true;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity logic = world.getTileEntity(x, y, z);
        if (logic != null && logic instanceof LavaTankLogic) {
            return ((LavaTankLogic)logic).getBrightness();
        }
        return 0;
    }

    public int getRenderType() {
        return TankRender.tankModelID;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (meta >= 3) {
            meta = 0;
        }
        if (meta == 0) {
            if (side == 0 || side == 1) {
                return this.icons[1];
            }
            return this.icons[0];
        }
        return this.icons[meta * 3 + this.getTextureIndex(side) - 1];
    }

    public int getTextureIndex(int side) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 0;
        }
        return 1;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new LavaTankLogic();
    }

    public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        ItemStack current = entityplayer.inventory.getCurrentItem();
        if (current != null) {
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
            LavaTankLogic logic = (LavaTankLogic)world.getTileEntity(i, j, k);
            if (liquid != null && !world.isRemote) {
                int amount = logic.fill(ForgeDirection.UNKNOWN, liquid, false);
                if (amount == liquid.amount) {
                    logic.fill(ForgeDirection.UNKNOWN, liquid, true);
                    if (!entityplayer.capabilities.isCreativeMode) {
                        entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, LavaTankBlock.consumeItem(current));
                    }
                    entityplayer.inventoryContainer.detectAndSendChanges();
                    world.markBlockForUpdate(i, j, k);
                }
                return true;
            }
            if (FluidContainerRegistry.isBucket((ItemStack)current)) {
                ItemStack fillStack;
                FluidTankInfo[] tanks = logic.getTankInfo(ForgeDirection.UNKNOWN);
                FluidStack fillFluid = tanks[0].fluid;
                if (!world.isRemote && (fillStack = FluidContainerRegistry.fillFluidContainer((FluidStack)fillFluid, (ItemStack)current)) != null) {
                    logic.drain(ForgeDirection.UNKNOWN, FluidContainerRegistry.getFluidForFilledItem((ItemStack)fillStack).amount, true);
                    if (!entityplayer.capabilities.isCreativeMode && !world.isRemote) {
                        if (current.stackSize == 1) {
                            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, fillStack);
                        } else {
                            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, LavaTankBlock.consumeItem(current));
                            if (!entityplayer.inventory.addItemStackToInventory(fillStack)) {
                                entityplayer.dropPlayerItemWithRandomChoice(fillStack, false);
                            }
                        }
                        entityplayer.inventoryContainer.detectAndSendChanges();
                    }
                    world.markBlockForUpdate(i, j, k);
                }
                return true;
            }
        }
        return false;
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.stackSize == 1) {
            if (stack.getItem().hasContainerItem()) {
                return stack.getItem().getContainerItem(stack);
            }
            return null;
        }
        stack.splitStack(1);
        return stack;
    }

    public TileEntity createNewTileEntity(World world, int test) {
        return this.createTileEntity(world, 0);
    }

    public void getSubBlocks(Item id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 3; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block nBlockID) {
        TileEntity logic = world.getTileEntity(x, y, z);
        if (logic instanceof IServantLogic) {
            ((IServantLogic)logic).notifyMasterOfChange();
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        player.addExhaustion(0.025f);
        int meta = world.getBlockMetadata(x, y, z);
        ItemStack stack = new ItemStack((Block)this, 1, meta);
        LavaTankLogic logic = (LavaTankLogic)world.getTileEntity(x, y, z);
        FluidStack liquid = logic.tank.getFluid();
        if (liquid != null) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound liquidTag = new NBTTagCompound();
            liquid.writeToNBT(liquidTag);
            tag.setTag("Fluid", (NBTBase)liquidTag);
            stack.setTagCompound(tag);
        }
        if (!player.capabilities.isCreativeMode || player.isSneaking()) {
            this.dropTankBlock(world, x, y, z, stack);
        }
        return world.setBlockToAir(x, y, z);
    }

    protected void dropTankBlock(World world, int x, int y, int z, ItemStack stack) {
        if (!world.isRemote && world.getGameRules().getGameRuleBooleanValue("doTileDrops")) {
            float f = 0.7f;
            double d0 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, stack);
            entityitem.delayBeforeCanPickup = 10;
            world.spawnEntityInWorld((Entity)entityitem);
        }
    }

    public void harvestBlock(World par1World, EntityPlayer par2EntityPlayer, int par3, int par4, int par5, int par6) {
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        NBTTagCompound liquidTag;
        if (stack.hasTagCompound() && (liquidTag = stack.getTagCompound().getCompoundTag("Fluid")) != null) {
            FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)liquidTag);
            LavaTankLogic logic = (LavaTankLogic)world.getTileEntity(x, y, z);
            logic.tank.setFluid(liquid);
        }
    }

    public boolean hasComparatorInputOverride() {
        return true;
    }

    public int getComparatorInputOverride(World world, int x, int y, int z, int comparatorSide) {
        return LavaTankBlock.getTankLogic((IBlockAccess)world, x, y, z).comparatorStrength();
    }

    public static LavaTankLogic getTankLogic(IBlockAccess blockAccess, int par1, int par2, int par3) {
        return (LavaTankLogic)blockAccess.getTileEntity(par1, par2, par3);
    }
}

