/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;

public class GlueFluid
extends BlockFluidFinite {
    IIcon stillIcon;
    IIcon flowIcon;
    boolean overwriteFluidIcons = true;

    public GlueFluid(Fluid fluid, Material material) {
        super(fluid, material);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.stillIcon = iconRegister.registerIcon("tinker:liquid_glue");
        this.flowIcon = iconRegister.registerIcon("tinker:liquid_glue_flow");
        if (this.overwriteFluidIcons) {
            this.getFluid().setIcons(this.stillIcon, this.flowIcon);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (side == 0 || side == 1) {
            return this.stillIcon;
        }
        return this.flowIcon;
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        entity.motionX *= 0.1;
        entity.motionZ *= 0.1;
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            living.addPotionEffect(new PotionEffect(Potion.hunger.getId(), 20, 4));
            living.addPotionEffect(new PotionEffect(Potion.moveSlowdown.getId(), 30, 4));
        }
    }

    public void suppressOverwritingFluidIcons() {
        this.overwriteFluidIcons = false;
    }
}

