/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.tools;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.modifier.ItemModifier;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.ToolCore;

public class ModRepair
extends ItemModifier {
    public ModRepair() {
        super(new ItemStack[0], 0, "");
    }

    @Override
    public boolean matches(ItemStack[] input, ItemStack tool) {
        return this.canModify(tool, input);
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        if (tags.getInteger("Damage") > 0) {
            int headID = tags.getInteger("Head");
            boolean areInputsValid = true;
            for (ItemStack curInput : input) {
                if (curInput == null || headID == PatternBuilder.instance.getPartID(curInput)) continue;
                areInputsValid = false;
                break;
            }
            if (areInputsValid) {
                return this.calculateIfNecessary(tool, input);
            }
        }
        return false;
    }

    private boolean calculateIfNecessary(ItemStack tool, ItemStack[] input) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        int damage = tags.getInteger("Damage");
        int numInputs = 0;
        int materialValue = 0;
        for (ItemStack curInput : input) {
            if (curInput == null) continue;
            materialValue += PatternBuilder.instance.getPartValue(curInput);
            ++numInputs;
        }
        if (numInputs == 0) {
            return false;
        }
        int totalRepairValue = this.calculateIncrease(tool, materialValue, numInputs);
        float averageRepairValue = totalRepairValue / numInputs;
        return numInputs == 1 || (float)(damage - totalRepairValue) >= -averageRepairValue;
    }

    private int calculateIncrease(ItemStack tool, int materialValue, int itemsUsed) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        int damage = tags.getInteger("Damage");
        int dur = tags.getInteger("BaseDurability");
        int increase = (int)((float)(50 * itemsUsed) + (float)dur * 0.4f * (float)materialValue);
        int modifiers = tags.getInteger("Modifiers");
        float mods = 1.0f;
        if (modifiers == 2) {
            mods = 0.9f;
        } else if (modifiers == 1) {
            mods = 0.8f;
        } else if (modifiers == 0) {
            mods = 0.7f;
        }
        increase = (int)((float)increase * mods);
        int repair = tags.getInteger("RepairCount");
        float repairCount = (float)(100 - repair) / 100.0f;
        if (repairCount < 0.5f) {
            repairCount = 0.5f;
        }
        increase = (int)((float)increase * repairCount);
        increase = (int)((float)increase / ((ToolCore)tool.getItem()).getRepairCost());
        return increase;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        tags.setBoolean("Broken", false);
        int damage = tags.getInteger("Damage");
        int dur = tags.getInteger("BaseDurability");
        int itemsUsed = 0;
        int materialValue = 0;
        for (ItemStack curInput : input) {
            if (curInput == null) continue;
            materialValue += PatternBuilder.instance.getPartValue(curInput);
            ++itemsUsed;
        }
        int increase = this.calculateIncrease(tool, materialValue, itemsUsed);
        int repair = tags.getInteger("RepairCount");
        tags.setInteger("RepairCount", repair += itemsUsed);
        if ((damage -= increase) < 0) {
            damage = 0;
        }
        tags.setInteger("Damage", damage);
        AbilityHelper.damageTool(tool, 0, null, true);
    }

    @Override
    public void addMatchingEffect(ItemStack tool) {
    }
}

