/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.tools;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.modifier.ItemModifier;
import tconstruct.util.config.PHConstruct;

public class ModDurability
extends ItemModifier {
    String tooltipName;
    String color;
    int durability;
    float modifier;
    int miningLevel;

    public ModDurability(ItemStack[] items, int effect, int dur, float mod, int level, String k, String tip, String c) {
        super(items, effect, k);
        this.durability = dur;
        this.modifier = mod;
        this.miningLevel = level;
        this.tooltipName = tip;
        this.color = c;
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        if (tags.hasKey(this.key)) {
            return false;
        }
        return super.canModify(tool, input);
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        int mLevel;
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        int base = tags.getInteger("BaseDurability");
        int bonus = tags.getInteger("BonusDurability");
        float modDur = tags.getFloat("ModDurability");
        int total = (int)((float)(base + (bonus += this.durability)) * ((modDur += this.modifier) + 1.0f));
        if (total <= 0) {
            total = 1;
        }
        tags.setInteger("TotalDurability", total);
        tags.setInteger("BonusDurability", bonus);
        tags.setFloat("ModDurability", modDur);
        if (PHConstruct.miningLevelIncrease && (mLevel = tags.getInteger("HarvestLevel")) < this.miningLevel) {
            tags.setInteger("HarvestLevel", this.miningLevel);
        }
        int modifiers = tags.getInteger("Modifiers");
        tags.setInteger("Modifiers", --modifiers);
        tags.setBoolean(this.key, true);
        String modTip = this.color + this.key;
        this.addToolTip(tool, this.tooltipName, modTip);
    }
}

