/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.tools;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import tconstruct.library.tools.ToolCore;
import tconstruct.modifiers.tools.ModBoolean;

public class ModButtertouch
extends ModBoolean {
    public ModButtertouch(ItemStack[] items, int effect) {
        super(items, effect, "Silk Touch", "\u00a7e", "Silky");
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        if (tool.getItem() instanceof ToolCore) {
            ToolCore toolItem = (ToolCore)tool.getItem();
            if (!this.validType(toolItem)) {
                return false;
            }
            NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
            if (!tags.getBoolean("Lava") && !tags.hasKey("Lapis")) {
                return tags.getInteger("Modifiers") > 0 && !tags.getBoolean(this.key);
            }
        }
        return false;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        tags.setBoolean(this.key, true);
        this.addEnchantment(tool, Enchantment.silkTouch, 1);
        int modifiers = tags.getInteger("Modifiers");
        tags.setInteger("Modifiers", --modifiers);
        int attack = tags.getInteger("Attack");
        if ((attack -= 3) < 0) {
            attack = 0;
        }
        tags.setInteger("Attack", attack);
        int miningSpeed = tags.getInteger("MiningSpeed");
        if ((miningSpeed -= 300) < 0) {
            miningSpeed = 0;
        }
        tags.setInteger("MiningSpeed", miningSpeed);
        if (tags.hasKey("MiningSpeed2")) {
            int miningSpeed2 = tags.getInteger("MiningSpeed2");
            if ((miningSpeed2 -= 300) < 0) {
                miningSpeed2 = 0;
            }
            tags.setInteger("MiningSpeed2", miningSpeed2);
        }
        this.addToolTip(tool, this.color + this.tooltipName, this.color + this.key);
    }

    public void addEnchantment(ItemStack tool, Enchantment enchant, int level) {
        NBTTagCompound enchantTag;
        NBTTagList tags = new NBTTagList();
        Map enchantMap = EnchantmentHelper.getEnchantments((ItemStack)tool);
        Iterator iterator = enchantMap.keySet().iterator();
        boolean hasEnchant = false;
        while (iterator.hasNext()) {
            enchantTag = new NBTTagCompound();
            int index = (Integer)iterator.next();
            int lvl = (Integer)enchantMap.get(index);
            if (index == enchant.effectId) {
                hasEnchant = true;
                enchantTag.setShort("id", (short)index);
                enchantTag.setShort("lvl", (short)((byte)level));
                tags.appendTag((NBTBase)enchantTag);
                continue;
            }
            enchantTag.setShort("id", (short)index);
            enchantTag.setShort("lvl", (short)((byte)lvl));
            tags.appendTag((NBTBase)enchantTag);
        }
        if (!hasEnchant) {
            enchantTag = new NBTTagCompound();
            enchantTag.setShort("id", (short)enchant.effectId);
            enchantTag.setShort("lvl", (short)((byte)level));
            tags.appendTag((NBTBase)enchantTag);
        }
        tool.stackTagCompound.setTag("ench", (NBTBase)tags);
    }

    public boolean validType(ToolCore tool) {
        List<String> list = Arrays.asList(tool.getTraits());
        return list.contains("weapon") || list.contains("harvest");
    }
}

