/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.armor;

import java.util.EnumSet;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.armor.ArmorCore;
import tconstruct.library.armor.ArmorMod;
import tconstruct.library.armor.ArmorPart;

public class AModBoolean
extends ArmorMod {
    String color;
    String tooltipName;

    public AModBoolean(int effect, String tag, EnumSet<ArmorPart> armorTypes, ItemStack[] items, String c, String tip) {
        super(effect, tag, armorTypes, items);
        this.color = c;
        this.tooltipName = tip;
    }

    @Override
    protected boolean canModify(ItemStack armor, ItemStack[] recipe) {
        Item i = armor.getItem();
        if (!(i instanceof ArmorCore)) {
            return false;
        }
        ArmorCore item = (ArmorCore)armor.getItem();
        if (!this.armorTypes.contains((Object)item.armorPart)) {
            return false;
        }
        NBTTagCompound tags = this.getModifierTag(armor);
        return tags.getInteger("Modifiers") > 0 && !tags.getBoolean(this.key);
    }

    @Override
    public void modify(ItemStack[] recipe, ItemStack input) {
        NBTTagCompound tags = this.getModifierTag(input);
        tags.setBoolean(this.key, true);
        int modifiers = tags.getInteger("Modifiers");
        tags.setInteger("Modifiers", --modifiers);
        this.addToolTip(input, this.color + this.tooltipName, this.color + this.key);
    }
}

