/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.mechworks.landmine.behavior;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import tconstruct.mechworks.itemblocks.ItemBlockLandmine;
import tconstruct.mechworks.landmine.behavior.Behavior;

public class BehaviorShears
extends Behavior {
    @Override
    public void executeLogic(World par1World, int par2, int par3, int par4, ItemStack par5ItemStack, Entity triggerer, boolean willBlockBeRemoved) {
        Random rand = ItemBlockLandmine.getRandom();
        List sheeps = par1World.getEntitiesWithinAABB(IShearable.class, AxisAlignedBB.getBoundingBox((double)(par2 - 2), (double)(par3 - 2), (double)(par4 - 2), (double)(par2 + 2), (double)(par3 + 2), (double)(par4 + 2)));
        if (sheeps != null && !sheeps.isEmpty()) {
            for (IShearable sheep : sheeps) {
                if (!sheep.isShearable(par5ItemStack, (IBlockAccess)par1World, par2, par3, par4) || rand.nextInt(2) != 0) continue;
                ArrayList drops = sheep.onSheared(par5ItemStack, (IBlockAccess)par1World, par2, par3, par4, EnchantmentHelper.getEnchantmentLevel((int)Enchantment.fortune.effectId, (ItemStack)par5ItemStack));
                if (sheep instanceof EntityLivingBase) {
                    par5ItemStack.damageItem(1, (EntityLivingBase)sheep);
                }
                Iterator i2 = drops.iterator();
                while (i2.hasNext()) {
                    if (sheep instanceof Entity) {
                        Entity ent = (Entity)sheep;
                        this.dropItem(par1World, (int)ent.posX, (int)ent.posY, (int)ent.posZ, (ItemStack)i2.next());
                        continue;
                    }
                    this.dropItem(par1World, par2, par3, par4, (ItemStack)i2.next());
                }
            }
        }
        if (willBlockBeRemoved) {
            this.dropItem(par1World, par2, par3, par4, par5ItemStack);
        }
    }

    protected void dropItem(World par1World, int par2, int par3, int par4, ItemStack par5ItemStack) {
        if (!par1World.isRemote && par1World.getGameRules().getGameRuleBooleanValue("doTileDrops")) {
            float f = 0.7f;
            double d0 = (double)(par1World.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(par1World.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(par1World.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(par1World, (double)par2 + d0, (double)par3 + d1, (double)par4 + d2, par5ItemStack);
            entityitem.delayBeforeCanPickup = 10;
            par1World.spawnEntityInWorld((Entity)entityitem);
        }
    }

    @Override
    public boolean shouldItemBeRemoved(ItemStack par1ItemStack, boolean willBlockBeRemoved) {
        return willBlockBeRemoved;
    }

    @Override
    public boolean isOffensive(ItemStack par1ItemStack) {
        return false;
    }

    @Override
    public boolean effectStacks() {
        return false;
    }
}

