/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.weaponry;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.weapons.IBattlegearWeapon;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import tconstruct.library.weaponry.AmmoItem;
import tconstruct.library.weaponry.IAccuracy;
import tconstruct.library.weaponry.IAmmo;
import tconstruct.library.weaponry.IWindup;
import tconstruct.tools.TinkerTools;
import tconstruct.weaponry.client.CrosshairType;

@Optional.InterfaceList(value={@Optional.Interface(modid="battlegear2", iface="mods.battlegear2.api.weapons.IBattlegearWeapon")})
public abstract class AmmoWeapon
extends AmmoItem
implements IBattlegearWeapon,
IAccuracy,
IWindup {
    public AmmoWeapon(int baseDamage, String name) {
        super(baseDamage, name);
    }

    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.none;
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 72000;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (this.getAmmoCount(stack) > 0) {
            player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        }
        return stack;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float clickX, float clickY, float clickZ) {
        return false;
    }

    @Override
    public int getWindupTime(ItemStack itemStack) {
        return 0;
    }

    @Override
    public float getMinWindupProgress(ItemStack itemStack) {
        return 0.0f;
    }

    public float getWindupProgress(ItemStack itemStack, int timeInUse) {
        float time = timeInUse;
        float windup = this.getWindupTime(itemStack);
        if (time > windup) {
            time = windup;
        }
        return time / windup;
    }

    @Override
    public float minAccuracy(ItemStack itemStack) {
        return 0.5f;
    }

    @Override
    public float maxAccuracy(ItemStack itemStack) {
        return 0.5f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getWindupProgress(ItemStack itemStack, EntityPlayer player) {
        if (player.inventory.getCurrentItem() != itemStack) {
            return 0.0f;
        }
        if (player.getItemInUse() == null) {
            return 0.0f;
        }
        return this.getWindupProgress(itemStack, this.getMaxItemUseDuration(itemStack) - player.getItemInUseCount());
    }

    @Override
    public float getAccuracy(ItemStack itemStack, int time) {
        float dif = this.minAccuracy(itemStack) - this.maxAccuracy(itemStack);
        return this.minAccuracy(itemStack) - dif * this.getWindupProgress(itemStack, time);
    }

    @Override
    public String[] getTraits() {
        return new String[]{"weapon", "thrown", "ammo", "windup"};
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityPlayer player, int durationLeft) {
        int time = this.getMaxItemUseDuration(stack) - durationLeft;
        if (this.getWindupProgress(stack, time) >= this.getMinWindupProgress(stack)) {
            this.launchProjectile(stack, world, player, time);
        }
    }

    protected void launchProjectile(ItemStack stack, World world, EntityPlayer player, int time) {
        if (!world.isRemote) {
            ItemStack reference = stack.copy();
            reference.stackSize = 1;
            ((IAmmo)reference.getItem()).setAmmo(1, reference);
            Entity projectile = this.createProjectile(reference, world, player, this.getAccuracy(stack, time), time);
            world.spawnEntityInWorld(projectile);
        }
        if (!player.capabilities.isCreativeMode) {
            this.consumeAmmo(1, stack);
        }
    }

    protected abstract Entity createProjectile(ItemStack var1, World var2, EntityPlayer var3, float var4, int var5);

    public abstract float getProjectileSpeed();

    @Override
    @SideOnly(value=Side.CLIENT)
    public CrosshairType getCrosshairType() {
        return CrosshairType.SQUARE;
    }

    @Override
    public boolean zoomOnWindup(ItemStack itemStack) {
        return false;
    }

    @Override
    public float getZoom(ItemStack itemStack) {
        return 1.0f;
    }

    @Override
    @Optional.Method(modid="battlegear2")
    public boolean sheatheOnBack(ItemStack item) {
        return true;
    }

    @Override
    @Optional.Method(modid="battlegear2")
    public boolean isOffhandHandDual(ItemStack off) {
        return true;
    }

    @Override
    @Optional.Method(modid="battlegear2")
    public boolean offhandAttackEntity(PlayerEventChild.OffhandAttackEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        return true;
    }

    @Override
    @Optional.Method(modid="battlegear2")
    public boolean offhandClickAir(PlayerInteractEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        this.onItemRightClick(offhandItem, event.entity.worldObj, event.entityPlayer);
        return true;
    }

    @Override
    @Optional.Method(modid="battlegear2")
    public boolean offhandClickBlock(PlayerInteractEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        return true;
    }

    @Override
    @Optional.Method(modid="battlegear2")
    public void performPassiveEffects(Side effectiveSide, ItemStack mainhandItem, ItemStack offhandItem) {
    }

    @Override
    @Optional.Method(modid="battlegear2")
    public boolean allowOffhand(ItemStack mainhand, ItemStack offhand) {
        if (offhand == null) {
            return true;
        }
        return mainhand != null && mainhand.getItem() != TinkerTools.cleaver && mainhand.getItem() != TinkerTools.battleaxe && offhand.getItem() != TinkerTools.cleaver && offhand.getItem() != TinkerTools.battleaxe;
    }
}

