/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.weapons.IBattlegearWeapon;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import tconstruct.library.tools.ToolCore;
import tconstruct.tools.TinkerTools;
import zeldaswordskills.api.item.ISword;

@Optional.InterfaceList(value={@Optional.Interface(modid="battlegear2", iface="mods.battlegear2.api.weapons.IBattlegearWeapon"), @Optional.Interface(modid="ZeldaItemAPI", iface="zeldaswordskills.api.item.ISword"), @Optional.Interface(modid="DynamicSkillsAPI", iface="dynamicswordskills.api.ISword")})
public abstract class Weapon
extends ToolCore
implements IBattlegearWeapon,
ISword,
dynamicswordskills.api.ISword {
    public static Material[] web = new Material[]{Material.web, Material.cloth, Material.coral, Material.cake};
    public static Material[] none = new Material[0];

    public Weapon(int baseDamage) {
        super(baseDamage);
    }

    protected float baseSpeed() {
        return 1.5f;
    }

    protected float effectiveSpeed() {
        return 15.0f;
    }

    @Override
    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (!stack.hasTagCompound()) {
            return 0.0f;
        }
        if (stack.getTagCompound().getCompoundTag("InfiTool").getBoolean("Broken")) {
            return 0.1f;
        }
        for (int i = 0; i < web.length; ++i) {
            if (web[i] != block.getMaterial()) continue;
            return this.effectiveSpeed();
        }
        return this.baseSpeed();
    }

    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.block;
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 72000;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        return stack;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float clickX, float clickY, float clickZ) {
        return false;
    }

    public boolean canHarvestBlock(Block block, ItemStack is) {
        for (int i = 0; i < web.length; ++i) {
            if (block.getMaterial() != web[i]) continue;
            return true;
        }
        return super.canHarvestBlock(block, is);
    }

    protected Material[] getEffectiveMaterials() {
        return web;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onUpdate(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        EntityPlayerSP player;
        ItemStack usingItem;
        super.onUpdate(stack, world, entity, par4, par5);
        if (entity instanceof EntityPlayerSP && (usingItem = (player = (EntityPlayerSP)entity).getItemInUse()) != null && usingItem.getItem() == this) {
            player.movementInput.moveForward *= 2.5f;
            player.movementInput.moveStrafe *= 2.5f;
        }
    }

    @Override
    public String[] getTraits() {
        return new String[]{"weapon", "melee"};
    }

    @Optional.Method(modid="battlegear2")
    public boolean sheatheOnBack(ItemStack item) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean isOffhandHandDual(ItemStack off) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandAttackEntity(PlayerEventChild.OffhandAttackEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickAir(PlayerInteractEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickBlock(PlayerInteractEvent event, ItemStack mainhandItem, ItemStack offhandItem) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public void performPassiveEffects(Side effectiveSide, ItemStack mainhandItem, ItemStack offhandItem) {
    }

    @Optional.Method(modid="battlegear2")
    public boolean allowOffhand(ItemStack mainhand, ItemStack offhand) {
        if (offhand == null) {
            return true;
        }
        return mainhand != null && mainhand.getItem() != TinkerTools.cleaver && mainhand.getItem() != TinkerTools.battleaxe && offhand.getItem() != TinkerTools.cleaver && offhand.getItem() != TinkerTools.battleaxe;
    }
}

