/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mantle.items.abstracts.CraftingItem;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.CustomMaterial;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.IToolPart;
import tconstruct.library.util.TextureHelper;
import tconstruct.util.config.PHConstruct;

public class DynamicToolPart
extends CraftingItem
implements IToolPart {
    public String partName;
    public String texture;
    public IIcon defaultIcon;
    public Class<? extends CustomMaterial> customMaterialClass;
    private boolean hidden = false;

    public DynamicToolPart(String texture, String name) {
        this(texture, name, (Class<? extends CustomMaterial>)null);
    }

    public DynamicToolPart(String texture, String name, Class<? extends CustomMaterial> customMaterialClass) {
        this(texture, name, "tinker", customMaterialClass);
    }

    public DynamicToolPart(String texture, String name, String domain) {
        this(texture, name, domain, null);
    }

    public DynamicToolPart(String texture, String name, String domain, Class<? extends CustomMaterial> customMaterialClass) {
        super(null, null, "parts/", domain, (CreativeTabs)TConstructRegistry.partTab);
        this.setUnlocalizedName("tconstruct." + name);
        this.partName = name;
        this.texture = texture;
        this.customMaterialClass = customMaterialClass;
    }

    public DynamicToolPart hide() {
        this.hidden = true;
        return this;
    }

    @Override
    public int getMaterialID(ItemStack stack) {
        if (TConstructRegistry.toolMaterials.keySet().contains(stack.getItemDamage())) {
            return stack.getItemDamage();
        }
        return -1;
    }

    public String getItemStackDisplayName(ItemStack stack) {
        String material = "";
        String matName = "";
        if (this.customMaterialClass == null) {
            ToolMaterial toolmat = TConstructRegistry.getMaterial(this.getMaterialID(stack));
            if (toolmat == null) {
                return super.getItemStackDisplayName(stack);
            }
            material = toolmat.localizationString.toLowerCase(Locale.ENGLISH).startsWith("material.") ? toolmat.localizationString.substring(9) : toolmat.localizationString;
            matName = toolmat.prefixName();
        } else {
            CustomMaterial customMaterial = TConstructRegistry.getCustomMaterial(this.getMaterialID(stack), this.customMaterialClass);
            if (customMaterial == null) {
                return super.getItemStackDisplayName(stack);
            }
            material = "";
            if (customMaterial.input != null) {
                material = customMaterial.input.getUnlocalizedName();
                int firstPeriodIndex = material.indexOf(46);
                if (firstPeriodIndex >= 0) {
                    material = material.substring(firstPeriodIndex + 1);
                }
                matName = customMaterial.input.getDisplayName();
            } else {
                material = customMaterial.oredict;
                matName = customMaterial.oredict;
            }
        }
        if (StatCollector.canTranslate((String)("toolpart." + this.partName + "." + material))) {
            return StatCollector.translateToLocal((String)("toolpart." + this.partName + "." + material));
        }
        if (StatCollector.canTranslate((String)("toolpart.material." + material))) {
            matName = StatCollector.translateToLocal((String)("toolpart.material." + material));
        }
        return StatCollector.translateToLocal((String)("toolpart." + this.partName)).replaceAll("%%material", matName);
    }

    public String getUnlocalizedName(ItemStack stack) {
        int id = this.getMaterialID(stack);
        if (id == -1) {
            return this.getUnlocalizedName();
        }
        String material = "unknown";
        if (this.customMaterialClass == null) {
            ToolMaterial toolmat = TConstructRegistry.getMaterial(this.getMaterialID(stack));
            material = toolmat.materialName;
        } else {
            CustomMaterial customMaterial = TConstructRegistry.getCustomMaterial(this.getMaterialID(stack), this.customMaterialClass);
            material = customMaterial.input != null ? customMaterial.input.getUnlocalizedName() : customMaterial.oredict;
        }
        return "toolpart." + this.partName + "." + material;
    }

    public void getSubItems(Item item, CreativeTabs tab, List list) {
        if (this.hidden) {
            return;
        }
        for (Integer matID : TConstructRegistry.defaultToolPartMaterials) {
            ItemStack stack = new ItemStack(item, 1, matID.intValue());
            if (this.getMaterialID(stack) == -1) continue;
            list.add(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        int max = -1;
        for (Integer n : TConstructRegistry.toolMaterials.keySet()) {
            if (n <= max) continue;
            max = n;
        }
        this.icons = new IIcon[max + 1];
        if (!PHConstruct.minimalTextures) {
            for (Map.Entry entry : TConstructRegistry.toolMaterials.entrySet()) {
                String tex = this.modTexPrefix + ":" + this.folder + ((ToolMaterial)entry.getValue()).materialName.toLowerCase() + this.texture;
                if (!TextureHelper.itemTextureExists(tex)) continue;
                this.icons[((Integer)entry.getKey()).intValue()] = iconRegister.registerIcon(tex);
            }
        }
        this.defaultIcon = iconRegister.registerIcon(this.modTexPrefix + ":" + this.folder + this.texture);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int meta) {
        if (meta > this.icons.length) {
            return this.defaultIcon;
        }
        if (this.icons[meta] == null) {
            return this.defaultIcon;
        }
        return this.icons[meta];
    }

    public int getColorFromItemStack(ItemStack stack, int renderpass) {
        int matId = this.getMaterialID(stack);
        if (matId > this.icons.length) {
            return super.getColorFromItemStack(stack, renderpass);
        }
        if (matId >= 0 && this.icons[matId] == null) {
            if (this.customMaterialClass == null) {
                return TConstructRegistry.getMaterial(this.getMaterialID(stack)).primaryColor();
            }
            return TConstructRegistry.getCustomMaterial((int)this.getMaterialID((ItemStack)stack), this.customMaterialClass).color;
        }
        return super.getColorFromItemStack(stack, renderpass);
    }
}

