/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.DynamicToolPart;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.TextureHelper;
import tconstruct.util.config.PHConstruct;

public class DualMaterialToolPart
extends DynamicToolPart {
    public IIcon defaultIcon2;
    public IIcon[] icons2;

    public DualMaterialToolPart(String textureType, String name) {
        super(textureType, name);
    }

    public static ItemStack createDualMaterial(Item item, int mat1, int mat2) {
        ItemStack stack = new ItemStack(item, 1, mat1);
        NBTTagCompound tags = new NBTTagCompound();
        NBTTagCompound subtag = new NBTTagCompound();
        subtag.setInteger("Material2", mat2);
        tags.setTag("DualMat", (NBTBase)subtag);
        stack.setTagCompound(tags);
        return stack;
    }

    public int getMaterialID2(ItemStack stack) {
        if (!stack.hasTagCompound()) {
            return -1;
        }
        int id = stack.getTagCompound().getCompoundTag("DualMat").getInteger("Material2");
        if (TConstructRegistry.toolMaterials.keySet().contains(id)) {
            return id;
        }
        return -1;
    }

    @Override
    public void getSubItems(Item item, CreativeTabs tab, List list) {
        for (Integer matID : TConstructRegistry.toolMaterials.keySet()) {
            list.add(DualMaterialToolPart.createDualMaterial(item, matID, 2));
        }
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        super.registerIcons(iconRegister);
        this.icons2 = new IIcon[this.icons.length];
        if (!PHConstruct.minimalTextures) {
            for (Map.Entry<Integer, ToolMaterial> entry : TConstructRegistry.toolMaterials.entrySet()) {
                String tex = this.modTexPrefix + ":" + this.folder + entry.getValue().materialName.toLowerCase() + this.texture + "_2";
                if (!TextureHelper.itemTextureExists(tex)) continue;
                this.icons2[entry.getKey().intValue()] = iconRegister.registerIcon(tex);
            }
        }
        this.defaultIcon2 = iconRegister.registerIcon(this.modTexPrefix + ":" + this.folder + this.texture + "_2");
    }

    public IIcon getIconFromDamageForRenderPass(int meta, int pass) {
        if (pass > 0) {
            if (meta > this.icons.length) {
                return this.defaultIcon2;
            }
            if (this.icons2[meta] == null) {
                return this.defaultIcon2;
            }
            return this.icons2[meta];
        }
        return super.getIconFromDamageForRenderPass(meta, pass);
    }

    @Override
    public int getColorFromItemStack(ItemStack stack, int renderpass) {
        if (renderpass > 0) {
            int matId = this.getMaterialID2(stack);
            if (matId > this.icons2.length || matId < 0) {
                return super.getColorFromItemStack(stack, renderpass);
            }
            if (this.icons[matId] == null) {
                return TConstructRegistry.getMaterial(matId).primaryColor();
            }
            return super.getColorFromItemStack(stack, renderpass);
        }
        return super.getColorFromItemStack(stack, renderpass);
    }
}

