/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.entity;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.weaponry.AmmoItem;
import tconstruct.util.Reference;
import tconstruct.weaponry.entity.ArrowEntity;

public abstract class ProjectileBase
extends EntityArrow
implements IEntityAdditionalSpawnData {
    public static final String woodSound = Reference.resource("woodHit");
    public static final String stoneSound = Reference.resource("stoneHit");
    public ItemStack returnStack;
    public boolean bounceOnNoDamage = true;
    public boolean defused = false;

    public ProjectileBase(World world) {
        super(world);
    }

    public ProjectileBase(World world, double d, double d1, double d2) {
        this(world);
        this.setPosition(d, d1, d2);
    }

    public ProjectileBase(World world, EntityPlayer player, float speed, float accuracy, ItemStack stack) {
        this(world);
        this.shootingEntity = player;
        this.canBePickedUp = 1;
        this.setLocationAndAngles(player.posX, player.posY + (double)player.getEyeHeight(), player.posZ, player.rotationYaw, player.rotationPitch);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.yOffset = 0.0f;
        this.motionX = -MathHelper.sin((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.motionZ = MathHelper.cos((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.motionY = -MathHelper.sin((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.setThrowableHeading(this.motionX, this.motionY, this.motionZ, speed, accuracy);
        this.returnStack = stack;
    }

    public ItemStack getEntityItem() {
        return this.returnStack;
    }

    protected void playHitBlockSound(int x, int y, int z) {
        Block block = this.worldObj.getBlock(x, y, z);
        if (block != null && block.blockMaterial == Material.wood) {
            this.worldObj.playSoundAtEntity((Entity)this, woodSound, 1.0f, 1.0f);
        } else {
            this.worldObj.playSoundAtEntity((Entity)this, stoneSound, 1.0f, 1.0f);
        }
        if (block != null) {
            this.worldObj.playSoundAtEntity((Entity)this, block.stepSound.getBreakSound(), 0.7f, 1.0f);
        }
    }

    protected void playHitEntitySound() {
    }

    protected double getStuckDepth() {
        return 0.5;
    }

    protected void doLivingHit(EntityLivingBase entityHit) {
        double horizontalSpeed;
        float knockback = this.returnStack.getTagCompound().getCompoundTag("InfiTool").getFloat("Knockback");
        if (this.shootingEntity instanceof EntityLivingBase) {
            knockback += (float)EnchantmentHelper.getKnockbackModifier((EntityLivingBase)((EntityLivingBase)this.shootingEntity), (EntityLivingBase)entityHit);
        }
        if (!this.worldObj.isRemote) {
            entityHit.setArrowCountInEntity(entityHit.getArrowCountInEntity() + 1);
        }
        if (knockback > 0.0f && (horizontalSpeed = (double)MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ))) > 0.0) {
            entityHit.addVelocity(this.motionX * (double)knockback * (double)0.6f / horizontalSpeed, 0.1, this.motionZ * (double)knockback * (double)0.6f / horizontalSpeed);
        }
        if (this.shootingEntity != null && this.shootingEntity instanceof EntityLivingBase) {
            EnchantmentHelper.func_151384_a((EntityLivingBase)entityHit, (Entity)this.shootingEntity);
            EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.shootingEntity), (Entity)entityHit);
        }
        if (this.shootingEntity != null && entityHit != this.shootingEntity && entityHit instanceof EntityPlayer && this.shootingEntity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this.shootingEntity).playerNetServerHandler.sendPacket((Packet)new S2BPacketChangeGameState(6, 0.0f));
        }
    }

    public void onHitBlock(MovingObjectPosition movingobjectposition) {
        this.field_145791_d = movingobjectposition.blockX;
        this.field_145792_e = movingobjectposition.blockY;
        this.field_145789_f = movingobjectposition.blockZ;
        this.field_145790_g = this.worldObj.getBlock(this.field_145791_d, this.field_145792_e, this.field_145789_f);
        this.inData = this.worldObj.getBlockMetadata(this.field_145791_d, this.field_145792_e, this.field_145789_f);
        this.motionX = movingobjectposition.hitVec.xCoord - this.posX;
        this.motionY = movingobjectposition.hitVec.yCoord - this.posY;
        this.motionZ = movingobjectposition.hitVec.zCoord - this.posZ;
        double speed = this.getStuckDepth() * (double)MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ));
        this.posX -= this.motionX / speed * (double)0.05f;
        this.posY -= this.motionY / speed * (double)0.05f;
        this.posZ -= this.motionZ / speed * (double)0.05f;
        this.playHitBlockSound(movingobjectposition.blockX, movingobjectposition.blockY, movingobjectposition.blockZ);
        this.inGround = true;
        this.arrowShake = 7;
        this.setIsCritical(false);
        this.defused = true;
        if (this.field_145790_g.getMaterial() != Material.air) {
            this.field_145790_g.onEntityCollidedWithBlock(this.worldObj, this.field_145791_d, this.field_145792_e, this.field_145789_f, (Entity)this);
        }
    }

    public void onHitEntity(MovingObjectPosition movingobjectposition) {
        NBTTagCompound tags = this.returnStack.getTagCompound().getCompoundTag("InfiTool");
        float speed = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ));
        float distance = speed * (float)(this.ticksInAir - 1);
        float dist2 = 0.0f;
        dist2 += MathHelper.abs((float)((float)movingobjectposition.entityHit.lastTickPosX - (float)this.lastTickPosX));
        dist2 += MathHelper.abs((float)((float)movingobjectposition.entityHit.lastTickPosY - (float)this.lastTickPosY));
        dist2 += MathHelper.abs((float)((float)movingobjectposition.entityHit.lastTickPosZ - (float)this.lastTickPosZ));
        dist2 = MathHelper.sqrt_double((double)dist2);
        distance += dist2;
        if (!tags.hasKey("BaseAttack")) {
            int atk = tags.getInteger("Attack");
            if (tags.hasKey("ModAttack")) {
                int bonusDmg = tags.getIntArray("ModAttack")[0] / 24 + 1;
                atk -= bonusDmg;
            }
            tags.setInteger("BaseAttack", atk);
        }
        float baseAttack = tags.getInteger("BaseAttack");
        float totalAttack = tags.getInteger("Attack");
        float damage = speed * baseAttack;
        damage += totalAttack - baseAttack;
        if (this instanceof ArrowEntity) {
            damage = Math.max(0.0f, damage - totalAttack / 2.0f);
        }
        boolean shotByPlayer = this.shootingEntity != null && this.shootingEntity instanceof EntityPlayer;
        ToolCore ammo = (ToolCore)this.returnStack.getItem();
        int baseDamage = 0;
        if (shotByPlayer) {
            for (ActiveToolMod toolmod : TConstructRegistry.activeModifiers) {
                int dmg = toolmod.baseAttackDamage(baseDamage, (int)damage, ammo, this.returnStack.getTagCompound(), tags, this.returnStack, (EntityLivingBase)((EntityPlayer)this.shootingEntity), movingobjectposition.entityHit);
                if (dmg <= baseDamage) continue;
                baseDamage = dmg;
            }
        }
        damage += (float)baseDamage;
        damage *= ammo.getDamageModifier();
        float bonusDamage = -AbilityHelper.calcStoneboundBonus(ammo, tags);
        if (this.shootingEntity != null && movingobjectposition.entityHit instanceof EntityLivingBase) {
            bonusDamage += EnchantmentHelper.getEnchantmentModifierLiving((EntityLivingBase)((EntityLivingBase)this.shootingEntity), (EntityLivingBase)((EntityLivingBase)movingobjectposition.entityHit));
        }
        if ((damage += bonusDamage) < 1.0f) {
            damage = 1.0f;
        }
        int modDamage = 0;
        if (shotByPlayer) {
            for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                modDamage += mod.attackDamage(modDamage, (int)damage, ammo, this.returnStack.getTagCompound(), tags, this.returnStack, (EntityLivingBase)((EntityPlayer)this.shootingEntity), movingobjectposition.entityHit);
            }
        }
        damage += (float)modDamage;
        if (this.getIsCritical()) {
            damage += (this.rand.nextFloat() / 4.0f + Math.min(0.75f, distance / 25.0f)) * (damage / 2.0f + 2.0f);
        }
        if (!this.dealDamage(damage, ammo, tags, movingobjectposition.entityHit)) {
            if (!this.bounceOnNoDamage) {
                this.setDead();
            }
            this.motionX *= (double)-0.1f;
            this.motionY *= (double)-0.1f;
            this.motionZ *= (double)-0.1f;
            this.rotationYaw += 180.0f;
            this.prevRotationYaw += 180.0f;
            this.ticksInAir = 0;
            return;
        }
        AbilityHelper.processFiery(this.shootingEntity, movingobjectposition.entityHit, tags);
        if (movingobjectposition.entityHit instanceof EntityLivingBase) {
            this.doLivingHit((EntityLivingBase)movingobjectposition.entityHit);
        }
        this.playHitEntitySound();
        if (!(movingobjectposition.entityHit instanceof EntityEnderman)) {
            if (this.rand.nextInt(10) + 1 > tags.getInteger("Reinforced")) {
                this.setDead();
            } else {
                this.motionX = Math.max(-0.1, Math.min(0.1, -this.motionX));
                this.motionY = 0.2;
                this.motionZ = Math.max(-0.1, Math.min(0.1, -this.motionZ));
                this.ticksInAir = 0;
                this.posX = movingobjectposition.entityHit.posX;
                this.posY = movingobjectposition.entityHit.posY + (double)movingobjectposition.entityHit.height / 2.0;
                this.posZ = movingobjectposition.entityHit.posZ;
                this.defused = true;
            }
        }
    }

    public boolean dealDamage(float damage, ToolCore ammo, NBTTagCompound tags, Entity entityHit) {
        boolean dealtDamage = false;
        DamageSource damagesource = this.shootingEntity == null ? DamageSource.causeArrowDamage((EntityArrow)this, (Entity)this) : DamageSource.causeArrowDamage((EntityArrow)this, (Entity)this.shootingEntity);
        dealtDamage = entityHit.attackEntityFrom(damagesource, damage);
        return dealtDamage;
    }

    public void setVelocity(double p_70016_1_, double p_70016_3_, double p_70016_5_) {
    }

    public void onUpdate() {
        Block block;
        this.onEntityUpdate();
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float f = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(this.motionY, f) * 180.0 / Math.PI);
        }
        if ((block = this.worldObj.getBlock(this.field_145791_d, this.field_145792_e, this.field_145789_f)).getMaterial() != Material.air) {
            block.setBlockBoundsBasedOnState((IBlockAccess)this.worldObj, this.field_145791_d, this.field_145792_e, this.field_145789_f);
            AxisAlignedBB axisalignedbb = block.getCollisionBoundingBoxFromPool(this.worldObj, this.field_145791_d, this.field_145792_e, this.field_145789_f);
            if (axisalignedbb != null && axisalignedbb.isVecInside(Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ))) {
                this.inGround = true;
            }
        }
        if (this.inGround) {
            this.updateInGround();
        } else {
            this.updateInAir();
        }
    }

    protected void updateInGround() {
        Block block = this.worldObj.getBlock(this.field_145791_d, this.field_145792_e, this.field_145789_f);
        int j = this.worldObj.getBlockMetadata(this.field_145791_d, this.field_145792_e, this.field_145789_f);
        if (block == this.field_145790_g && j == this.inData) {
            ++this.ticksInGround;
            if (this.ticksInGround == 1200) {
                this.setDead();
            }
        } else {
            this.inGround = false;
            this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
            this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
            this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
            this.ticksInGround = 0;
            this.ticksInAir = 0;
        }
    }

    protected void updateInAir() {
        ++this.ticksInAir;
        Vec3 curPos = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
        Vec3 newPos = Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
        MovingObjectPosition movingobjectposition = this.worldObj.func_147447_a(curPos, newPos, false, true, false);
        curPos = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
        newPos = movingobjectposition != null ? Vec3.createVectorHelper((double)movingobjectposition.hitVec.xCoord, (double)movingobjectposition.hitVec.yCoord, (double)movingobjectposition.hitVec.zCoord) : Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
        if (!this.defused) {
            Entity entity = null;
            List list = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
            double distance = 0.0;
            for (Entity ent : list) {
                double otherDistance;
                float f1;
                AxisAlignedBB axisalignedbb1;
                MovingObjectPosition movingobjectposition1;
                if (!ent.canBeCollidedWith() || ent == this.shootingEntity && this.ticksInAir < 5 || (movingobjectposition1 = (axisalignedbb1 = ent.boundingBox.expand((double)(f1 = 0.3f), (double)f1, (double)f1)).calculateIntercept(curPos, newPos)) == null || !((otherDistance = curPos.distanceTo(movingobjectposition1.hitVec)) < distance) && distance != 0.0) continue;
                entity = ent;
                distance = otherDistance;
            }
            if (entity != null) {
                movingobjectposition = new MovingObjectPosition(entity);
            }
            if (movingobjectposition != null && movingobjectposition.entityHit != null && movingobjectposition.entityHit instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)movingobjectposition.entityHit;
                if (entityplayer.capabilities.disableDamage || this.shootingEntity instanceof EntityPlayer && !((EntityPlayer)this.shootingEntity).canAttackPlayer(entityplayer)) {
                    movingobjectposition = null;
                }
            }
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.entityHit != null) {
                this.onHitEntity(movingobjectposition);
            } else {
                this.onHitBlock(movingobjectposition);
            }
        }
        if (this.getIsCritical()) {
            this.drawCritParticles();
        }
        this.doMoveUpdate();
        double slowdown = 1.0 - this.getSlowdown();
        if (this.isInWater()) {
            for (int l = 0; l < 4; ++l) {
                float f4 = 0.25f;
                this.worldObj.spawnParticle("bubble", this.posX - this.motionX * (double)f4, this.posY - this.motionY * (double)f4, this.posZ - this.motionZ * (double)f4, this.motionX, this.motionY, this.motionZ);
            }
            slowdown = 1.0 - 20.0 * this.getSlowdown();
        }
        if (this.isWet()) {
            this.extinguish();
        }
        this.motionX *= slowdown;
        this.motionY *= slowdown;
        this.motionZ *= slowdown;
        this.motionY -= this.getGravity();
        this.setPosition(this.posX, this.posY, this.posZ);
        this.func_145775_I();
    }

    public void drawCritParticles() {
        for (int i = 0; i < 4; ++i) {
            this.worldObj.spawnParticle("crit", this.posX + this.motionX * (double)i / 4.0, this.posY + this.motionY * (double)i / 4.0, this.posZ + this.motionZ * (double)i / 4.0, -this.motionX, -this.motionY + 0.2, -this.motionZ);
        }
    }

    protected void doMoveUpdate() {
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        double f2 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
        this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
        this.rotationPitch = (float)(Math.atan2(this.motionY, f2) * 180.0 / Math.PI);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
    }

    protected double getSlowdown() {
        return 0.01;
    }

    protected double getGravity() {
        return 0.05;
    }

    public void onCollideWithPlayer(EntityPlayer player) {
        if (!this.worldObj.isRemote && this.inGround && this.arrowShake <= 0) {
            boolean flag;
            boolean bl = flag = this.canBePickedUp == 1 || this.canBePickedUp == 2 && player.capabilities.isCreativeMode;
            if (this.canBePickedUp == 1) {
                if (this.returnStack != null && this.returnStack.getItem() instanceof AmmoItem) {
                    if (!((AmmoItem)this.returnStack.getItem()).pickupAmmo(this.returnStack, null, player)) {
                        flag = false;
                    }
                } else if (this.returnStack != null && !player.inventory.addItemStackToInventory(this.returnStack)) {
                    flag = false;
                }
            }
            if (flag) {
                this.playSound("random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.onItemPickup((Entity)this, 1);
                this.setDead();
            }
        }
    }

    public void writeEntityToNBT(NBTTagCompound tags) {
        super.writeEntityToNBT(tags);
        tags.setTag("Throwable", (NBTBase)this.returnStack.writeToNBT(new NBTTagCompound()));
        tags.setByte("onGround", (byte)(this.onGround ? 1 : 0));
    }

    public void readEntityFromNBT(NBTTagCompound tags) {
        super.readEntityFromNBT(tags);
        this.returnStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)tags.getCompoundTag("Throwable"));
        boolean bl = this.onGround = tags.getByte("onGround") == 1;
        if (this.returnStack == null || !(this.returnStack.getItem() instanceof ToolCore)) {
            this.setDead();
        }
    }

    public void writeSpawnData(ByteBuf data) {
        ByteBufUtils.writeItemStack((ByteBuf)data, (ItemStack)this.returnStack);
        data.writeFloat(this.rotationYaw);
        int id = this.shootingEntity == null ? this.getEntityId() : this.shootingEntity.getEntityId();
        data.writeInt(id);
        data.writeDouble(this.motionX);
        data.writeDouble(this.motionY);
        data.writeDouble(this.motionZ);
    }

    public void readSpawnData(ByteBuf data) {
        this.returnStack = ByteBufUtils.readItemStack((ByteBuf)data);
        this.rotationYaw = data.readFloat();
        this.shootingEntity = this.worldObj.getEntityByID(data.readInt());
        this.motionX = data.readDouble();
        this.motionY = data.readDouble();
        this.motionZ = data.readDouble();
        this.posX -= (double)(MathHelper.cos((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.posY -= (double)0.1f;
        this.posZ -= (double)(MathHelper.sin((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * 0.16f);
    }
}

