/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.crafting;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.library.crafting.ToolRecipe;
import tconstruct.library.event.ToolBuildEvent;
import tconstruct.library.event.ToolCraftEvent;
import tconstruct.library.modifier.ItemModifier;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.IToolPart;

public class ToolBuilder {
    public static ToolBuilder instance = new ToolBuilder();
    public HashMap<String, ToolRecipe> recipeList = new HashMap();
    public List<ToolRecipe> combos = new ArrayList<ToolRecipe>();
    public HashMap<String, String> modifiers = new HashMap();

    public static void addNormalToolRecipe(ToolCore output, Item head, Item handle) {
        ToolRecipe recipe = ToolBuilder.instance.recipeList.get(output.getToolName());
        if (recipe != null) {
            recipe.addHeadItem(head);
            recipe.addHandleItem(handle);
        } else {
            recipe = new ToolRecipe(head, handle, output);
            ToolBuilder.instance.combos.add(recipe);
            ToolBuilder.instance.recipeList.put(output.getToolName(), recipe);
        }
    }

    public static void addNormalToolRecipe(ToolCore output, Item head, Item handle, Item accessory) {
        ToolRecipe recipe = ToolBuilder.instance.recipeList.get(output.getToolName());
        if (recipe != null) {
            recipe.addHeadItem(head);
            recipe.addHandleItem(handle);
            recipe.addAccessoryItem(accessory);
        } else {
            recipe = new ToolRecipe(head, handle, accessory, output);
            ToolBuilder.instance.combos.add(recipe);
            ToolBuilder.instance.recipeList.put(output.getToolName(), recipe);
        }
    }

    public static void addNormalToolRecipe(ToolCore output, Item head, Item handle, Item accessory, Item extra) {
        ToolRecipe recipe = ToolBuilder.instance.recipeList.get(output.getToolName());
        if (recipe != null) {
            recipe.addHeadItem(head);
            recipe.addHandleItem(handle);
            recipe.addAccessoryItem(accessory);
            recipe.addExtraItem(extra);
        } else {
            recipe = new ToolRecipe(head, handle, accessory, extra, output);
            ToolBuilder.instance.combos.add(recipe);
            ToolBuilder.instance.recipeList.put(output.getToolName(), recipe);
        }
    }

    public static void addCustomToolRecipe(ToolRecipe recipe) {
        ToolBuilder.instance.combos.add(recipe);
    }

    public static void addToolRecipe(ToolCore output, Item ... items) {
        if (items.length == 2) {
            ToolBuilder.addNormalToolRecipe(output, items[0], items[1]);
        }
        if (items.length == 3) {
            ToolBuilder.addNormalToolRecipe(output, items[0], items[1], items[2]);
        }
        if (items.length == 4) {
            ToolBuilder.addNormalToolRecipe(output, items[0], items[1], items[2], items[3]);
        }
    }

    public ToolCore getMatchingRecipe(Item head, Item handle, Item accessory, Item extra) {
        for (ToolRecipe recipe : this.combos) {
            if (!recipe.validHead(head) || !recipe.validHandle(handle) || !recipe.validAccessory(accessory) || !recipe.validExtra(extra)) continue;
            return recipe.getType();
        }
        return null;
    }

    public ItemStack buildTool(ItemStack headStack, ItemStack handleStack, ItemStack accessoryStack, String name) {
        return this.buildTool(headStack, handleStack, accessoryStack, null, name);
    }

    public int getMaterialID(ItemStack stack) {
        if (stack == null) {
            return -1;
        }
        Item item = stack.getItem();
        if (item instanceof IToolPart) {
            return ((IToolPart)item).getMaterialID(stack);
        }
        return -1;
    }

    public ItemStack buildTool(ItemStack headStack, ItemStack handleStack, ItemStack accessoryStack, ItemStack extraStack, String name) {
        ToolCore item;
        if (headStack == null || handleStack == null) {
            return null;
        }
        if (name == null) {
            name = "";
        }
        ToolBuildEvent buildEvent = new ToolBuildEvent(headStack, handleStack, accessoryStack, extraStack, name);
        MinecraftForge.EVENT_BUS.post((Event)buildEvent);
        headStack = buildEvent.headStack;
        handleStack = buildEvent.handleStack;
        accessoryStack = buildEvent.accessoryStack;
        extraStack = buildEvent.extraStack;
        name = buildEvent.name;
        boolean validMaterials = true;
        int head = -1;
        int handle = -1;
        int accessory = -1;
        int extra = -1;
        head = this.getMaterialID(headStack);
        if (head == -1) {
            validMaterials = false;
        }
        if ((handle = this.getMaterialID(handleStack)) == -1) {
            validMaterials = false;
        }
        if (!validMaterials) {
            return null;
        }
        if (accessoryStack == null) {
            item = this.getMatchingRecipe(headStack.getItem(), handleStack.getItem(), null, null);
        } else {
            accessory = this.getMaterialID(accessoryStack);
            if (accessory == -1) {
                return null;
            }
            if (extraStack != null) {
                extra = this.getMaterialID(extraStack);
                if (extra == -1) {
                    return null;
                }
                item = this.getMatchingRecipe(headStack.getItem(), handleStack.getItem(), accessoryStack.getItem(), extraStack.getItem());
            } else {
                item = this.getMatchingRecipe(headStack.getItem(), handleStack.getItem(), accessoryStack.getItem(), null);
            }
        }
        if (item == null) {
            return null;
        }
        ToolMaterial headMat = null;
        ToolMaterial handleMat = null;
        ToolMaterial accessoryMat = null;
        ToolMaterial extraMat = null;
        headMat = TConstructRegistry.getMaterial(head);
        handleMat = TConstructRegistry.getMaterial(handle);
        if (accessory != -1) {
            accessoryMat = TConstructRegistry.getMaterial(accessory);
        }
        if (extra != -1) {
            extraMat = TConstructRegistry.getMaterial(extra);
        }
        int durability = headMat.durability();
        int heads = 1;
        int handles = 0;
        float modifier = 1.0f;
        int attack = headMat.attack();
        if (item.durabilityTypeHandle() == 2) {
            ++heads;
            durability += handleMat.durability();
            attack += handleMat.attack();
        } else if (item.durabilityTypeHandle() == 1) {
            ++handles;
            modifier = handleMat.handleDurability();
        }
        if (accessory != -1) {
            if (item.durabilityTypeAccessory() == 2) {
                ++heads;
                durability += accessoryMat.durability();
                attack += accessoryMat.attack();
            } else if (item.durabilityTypeAccessory() == 1) {
                ++handles;
                modifier += accessoryMat.handleDurability();
            }
        }
        if (extra != -1) {
            if (item.durabilityTypeExtra() == 2) {
                ++heads;
                durability += extraMat.durability();
                attack += extraMat.attack();
            } else if (item.durabilityTypeExtra() == 1) {
                ++handles;
                modifier += extraMat.handleDurability();
            }
        }
        if (handles > 0) {
            modifier = (float)((double)modifier * (0.5 + (double)handles * 0.5));
            modifier /= (float)handles;
        }
        durability = (int)((double)(durability / heads) * (0.5 + (double)heads * 0.5) * (double)modifier * (double)item.getDurabilityModifier());
        if ((attack = attack / heads + item.getDamageVsEntity(null)) % heads != 0) {
            ++attack;
        }
        Object tool = new ItemStack((Item)item);
        NBTTagCompound compound = new NBTTagCompound();
        compound.setTag("InfiTool", (NBTBase)new NBTTagCompound());
        compound.getCompoundTag("InfiTool").setInteger("Head", head);
        compound.getCompoundTag("InfiTool").setInteger("RenderHead", head);
        compound.getCompoundTag("InfiTool").setInteger("Handle", handle);
        compound.getCompoundTag("InfiTool").setInteger("RenderHandle", handle);
        if (accessory != -1) {
            compound.getCompoundTag("InfiTool").setInteger("Accessory", accessory);
            compound.getCompoundTag("InfiTool").setInteger("RenderAccessory", accessory);
        }
        if (extra != -1) {
            compound.getCompoundTag("InfiTool").setInteger("Extra", extra);
            compound.getCompoundTag("InfiTool").setInteger("RenderExtra", extra);
        }
        compound.getCompoundTag("InfiTool").setInteger("Damage", 0);
        compound.getCompoundTag("InfiTool").setInteger("TotalDurability", durability);
        compound.getCompoundTag("InfiTool").setInteger("BaseDurability", durability);
        compound.getCompoundTag("InfiTool").setInteger("BonusDurability", 0);
        compound.getCompoundTag("InfiTool").setFloat("ModDurability", 0.0f);
        compound.getCompoundTag("InfiTool").setBoolean("Broken", false);
        compound.getCompoundTag("InfiTool").setInteger("Attack", attack);
        compound.getCompoundTag("InfiTool").setInteger("BaseAttack", attack);
        compound.getCompoundTag("InfiTool").setInteger("MiningSpeed", headMat.toolSpeed());
        compound.getCompoundTag("InfiTool").setInteger("HarvestLevel", headMat.harvestLevel());
        if (item.durabilityTypeHandle() == 2) {
            compound.getCompoundTag("InfiTool").setInteger("MiningSpeedHandle", handleMat.toolSpeed());
            compound.getCompoundTag("InfiTool").setInteger("HarvestLevelHandle", handleMat.harvestLevel());
        }
        if (accessory != -1 && item.durabilityTypeAccessory() == 2) {
            compound.getCompoundTag("InfiTool").setInteger("MiningSpeed2", accessoryMat.toolSpeed());
            compound.getCompoundTag("InfiTool").setInteger("HarvestLevel2", accessoryMat.harvestLevel());
        }
        if (extra != -1 && item.durabilityTypeExtra() == 2) {
            compound.getCompoundTag("InfiTool").setInteger("MiningSpeedExtra", extraMat.toolSpeed());
            compound.getCompoundTag("InfiTool").setInteger("HarvestLevelExtra", extraMat.harvestLevel());
        }
        compound.getCompoundTag("InfiTool").setInteger("Unbreaking", this.buildReinforced(headMat, handleMat, accessoryMat, extraMat));
        compound.getCompoundTag("InfiTool").setFloat("Shoddy", this.buildShoddy(headMat, handleMat, accessoryMat, extraMat));
        compound.getCompoundTag("InfiTool").setInteger("Modifiers", item.getModifierAmount());
        if (name != null && !name.equals("")) {
            compound.setTag("display", (NBTBase)new NBTTagCompound());
            compound.getCompoundTag("display").setString("Name", "\u00a7f" + name);
        } else {
            compound.setTag("display", (NBTBase)new NBTTagCompound());
            compound.getCompoundTag("display").setString("Name", "\u00a7f" + ToolBuilder.defaultToolName(headMat, item));
        }
        ToolCraftEvent.NormalTool event = new ToolCraftEvent.NormalTool(item, compound, new ToolMaterial[]{headMat, handleMat, accessoryMat, extraMat});
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DEFAULT) {
            tool.setTagCompound(compound);
        } else {
            tool = event.getResult() == Event.Result.ALLOW ? event.getResultStack() : null;
        }
        return tool;
    }

    int buildReinforced(ToolMaterial headMat, ToolMaterial handleMat, ToolMaterial accessoryMat, ToolMaterial extraMat) {
        int reinforced = 0;
        int dHead = headMat.reinforced();
        int dHandle = handleMat.reinforced();
        int dAccessory = 0;
        if (accessoryMat != null) {
            dAccessory = accessoryMat.reinforced();
        }
        int dExtra = 0;
        if (extraMat != null) {
            dExtra = extraMat.reinforced();
        }
        if (dHead > reinforced) {
            reinforced = dHead;
        }
        if (dHandle > reinforced) {
            reinforced = dHandle;
        }
        if (dAccessory > reinforced) {
            reinforced = dAccessory;
        }
        if (dExtra > reinforced) {
            reinforced = dExtra;
        }
        return reinforced;
    }

    float buildShoddy(ToolMaterial headMat, ToolMaterial handleMat, ToolMaterial accessoryMat, ToolMaterial extraMat) {
        float sHead = headMat.shoddy();
        float sHandle = handleMat.shoddy();
        if (extraMat != null) {
            float sAccessory = accessoryMat.shoddy();
            float sExtra = extraMat.shoddy();
            return (sHead + sHandle + sAccessory + sExtra) / 4.0f;
        }
        if (accessoryMat != null) {
            float sAccessory = accessoryMat.shoddy();
            return (sHead + sHandle + sAccessory) / 3.0f;
        }
        return (sHead + sHandle) / 2.0f;
    }

    public static String defaultToolName(ItemStack stack) {
        if (!stack.hasTagCompound() || !stack.getTagCompound().hasKey("InfiTool")) {
            return null;
        }
        if (!(stack.getItem() instanceof ToolCore)) {
            return null;
        }
        int mat = stack.getTagCompound().getCompoundTag("InfiTool").getInteger("Head");
        return ToolBuilder.defaultToolName(TConstructRegistry.getMaterial(mat), (ToolCore)stack.getItem());
    }

    public static String defaultToolName(ToolMaterial headMat, ToolCore tool) {
        String toolName = tool.getToolName().toLowerCase();
        String matName = headMat.materialName.toLowerCase().replaceAll(" ", "").replaceAll("_", "");
        if (StatCollector.canTranslate((String)("tool." + toolName + "." + matName))) {
            return StatCollector.translateToLocal((String)("tool." + toolName + "." + matName));
        }
        return String.format("%s %s", headMat.prefixName(), tool.getLocalizedToolName());
    }

    @Deprecated
    public static void registerToolMod(ItemModifier mod) {
        ModifyBuilder.registerModifier(mod);
    }
}

