/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.armor;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.item.ItemStack;
import tconstruct.library.armor.ArmorMod;
import tconstruct.library.armor.ArmorPart;

public abstract class ArmorModTypeFilter
extends ArmorMod {
    public final List<Integer> increase;

    public ArmorModTypeFilter(int effect, String dataKey, EnumSet<ArmorPart> armorTypes, ItemStack[] items, int[] values) {
        super(effect, dataKey, armorTypes, items);
        assert (items.length == values.length) : "Itemstacks and their values for armor modifiers must be the same length";
        this.increase = new ArrayList<Integer>();
        for (int i = 0; i < values.length; ++i) {
            this.increase.add(values[i]);
        }
    }

    @Override
    public boolean matches(ItemStack[] input, ItemStack tool) {
        if (!this.canModify(tool, input)) {
            return false;
        }
        boolean minimumMatch = false;
        for (ItemStack inputStack : input) {
            if (inputStack == null) continue;
            boolean match = false;
            for (Object check : this.stacks) {
                ItemStack stack = (ItemStack)check;
                if (stack.getItemDamage() == Short.MAX_VALUE) {
                    if (!this.areItemsEquivalent(inputStack, stack)) continue;
                    match = true;
                    continue;
                }
                if (!this.areItemStacksEquivalent(inputStack, stack)) continue;
                match = true;
            }
            if (!match) {
                return false;
            }
            minimumMatch = true;
        }
        return minimumMatch;
    }

    public int matchingAmount(ItemStack[] input) {
        int amount = 0;
        for (ItemStack inputStack : input) {
            if (inputStack == null) continue;
            for (int iter = 0; iter < this.stacks.size(); ++iter) {
                ItemStack stack = (ItemStack)this.stacks.get(iter);
                if (stack.getItemDamage() == Short.MAX_VALUE) {
                    if (!this.areItemsEquivalent(inputStack, stack)) continue;
                    amount += this.increase.get(iter).intValue();
                    continue;
                }
                if (!this.areItemStacksEquivalent(inputStack, stack)) continue;
                amount += this.increase.get(iter).intValue();
            }
        }
        return amount;
    }

    public int matchingItems(ItemStack[] input) {
        int amount = 0;
        for (ItemStack inputStack : input) {
            if (inputStack == null) continue;
            ++amount;
        }
        return amount;
    }

    public void addStackToMatchList(ItemStack stack, int amount) {
        if (stack == null) {
            throw new NullPointerException("ItemStack added to " + this.getClass().getSimpleName() + " cannot be null.");
        }
        this.stacks.add(stack);
        this.increase.add(amount);
    }
}

