/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.armor;

import java.util.EnumSet;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.armor.ArmorCore;
import tconstruct.library.armor.ArmorPart;
import tconstruct.library.modifier.IModifyable;
import tconstruct.library.modifier.ItemModifier;

public abstract class ArmorMod
extends ItemModifier {
    protected final EnumSet<ArmorPart> armorTypes;

    public ArmorMod(int effect, String dataKey, EnumSet<ArmorPart> armorTypes, ItemStack[] items) {
        super(items, effect, dataKey);
        this.armorTypes = armorTypes;
    }

    @Override
    protected boolean canModify(ItemStack armor, ItemStack[] input) {
        Item i = armor.getItem();
        if (!(i instanceof ArmorCore)) {
            return false;
        }
        ArmorCore item = (ArmorCore)armor.getItem();
        if (this.armorTypes.contains((Object)item.armorPart)) {
            NBTTagCompound tags = this.getModifierTag(armor);
            return tags.getInteger("Modifiers") > 0;
        }
        return false;
    }

    @Override
    public boolean validType(IModifyable type) {
        return type.getModifyType().equals("Armor") || type.getModifyType().equals("Clothing");
    }
}

