/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.armor.ArmorPart;
import tconstruct.library.armor.BehaviorDispenseArmorCopy;
import tconstruct.library.modifier.ActiveArmorMod;
import tconstruct.library.modifier.IModifyable;
import tconstruct.library.tools.ToolCore;
import tconstruct.tools.entity.FancyEntityItem;

public abstract class ArmorCore
extends ItemArmor
implements ISpecialArmor,
IModifyable {
    public final ArmorPart armorPart;
    private static final IBehaviorDispenseItem dispenserBehavior = new BehaviorDispenseArmorCopy();
    public final int baseProtection;
    protected final String modifyType;
    protected final String textureFolder;
    protected final String textureName;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] modifiers;
    private DecimalFormat df = new DecimalFormat("##.#");

    public ArmorCore(int baseProtection, ArmorPart part, String type, String textureFolder, String textureName) {
        super(ItemArmor.ArmorMaterial.CHAIN, 0, part.getPartId());
        this.maxStackSize = 1;
        this.setMaxDamage(100);
        this.armorPart = part;
        this.baseProtection = baseProtection;
        this.modifyType = type;
        this.textureFolder = textureFolder;
        this.textureName = textureName;
        BlockDispenser.dispenseBehaviorRegistry.putObject((Object)this, (Object)dispenserBehavior);
        this.setCreativeTab(TConstructRegistry.equipableTab);
    }

    public ArmorCore(int baseProtection, ArmorPart part, String type, String textureName) {
        this(baseProtection, part, type, "armor", textureName);
    }

    public abstract ItemStack getRepairMaterial(ItemStack var1);

    public String getArmorName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getBaseTagName() {
        return "TinkerArmor";
    }

    @Override
    public String getModifyType() {
        return this.modifyType;
    }

    @Override
    public String[] getTraits() {
        return new String[]{"armor"};
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        int i = EntityLiving.getArmorPosition((ItemStack)stack) - 1;
        ItemStack itemstack1 = player.getCurrentArmor(i);
        if (itemstack1 == null) {
            player.setCurrentItemOrArmor(i + 1, stack.copy());
            stack.stackSize = 0;
        }
        return stack;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        for (ActiveArmorMod mod : TConstructRegistry.activeArmorModifiers) {
            mod.onArmorTick(world, player, itemStack, this, this.armorPart);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (slot == 2) {
            return "tinker:textures/armor/" + this.textureName + "_" + 2 + ".png";
        }
        return "tinker:textures/armor/" + this.textureName + "_" + 1 + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("tinker:" + this.textureFolder + "/" + this.textureName + (this.armorType == 0 ? "helmet" : (this.armorType == 1 ? "chestplate" : (this.armorType == 2 ? "pants" : (this.armorType == 3 ? "boots" : "helmet")))));
        this.registerModifiers(iconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        if (renderPass > 0) {
            if (stack.hasTagCompound()) {
                NBTTagCompound tags = stack.getTagCompound().getCompoundTag(this.getBaseTagName());
                if (renderPass == 1 && tags.hasKey("Effect1")) {
                    return this.modifiers[tags.getInteger("Effect1")];
                }
                if (renderPass == 2 && tags.hasKey("Effect2")) {
                    return this.modifiers[tags.getInteger("Effect2")];
                }
                if (renderPass == 3 && tags.hasKey("Effect3")) {
                    return this.modifiers[tags.getInteger("Effect3")];
                }
            }
            return ToolCore.blankSprite;
        }
        return this.itemIcon;
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerModifiers(IIconRegister iconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 4;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack par1ItemStack) {
        return false;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (!armor.hasTagCompound() || source.isUnblockable()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        NBTTagCompound tags = armor.getTagCompound().getCompoundTag(this.getBaseTagName());
        if (tags.getBoolean("Broken")) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        double current = this.getProtection(tags);
        return new ISpecialArmor.ArmorProperties(0, current / 100.0, 100);
    }

    public double getProtection(ItemStack stack) {
        return this.getProtection(stack.getTagCompound().getCompoundTag(this.getBaseTagName()));
    }

    public double getProtection(NBTTagCompound tags) {
        float maxDurability = tags.getInteger("TotalDurability");
        float currentDurability = maxDurability - (float)tags.getInteger("Damage");
        float ratio = currentDurability / maxDurability;
        double base = tags.getDouble("BaseDefense");
        double max = tags.getDouble("MaxDefense");
        double current = (max - base) * (double)ratio + base;
        return current;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (slot != 1) {
            ItemStack stack = player.getCurrentArmor(1);
            if (stack != null && stack.getItem() instanceof ArmorCore) {
                return 0;
            }
            return this.disconnectedArmorDisplay(player, armor, slot);
        }
        return this.combinedArmorDisplay(player, armor);
    }

    protected int disconnectedArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (!armor.hasTagCompound()) {
            return 0;
        }
        NBTTagCompound armorTag = armor.getTagCompound().getCompoundTag(this.getBaseTagName());
        if (armorTag.getBoolean("Broken")) {
            return 0;
        }
        float max = armorTag.getInteger("TotalDurability");
        float current = max - (float)armorTag.getInteger("Damage");
        float amount = current / max * 5.0f + 0.09f;
        if (slot == 2 && amount < 1.0f) {
            amount = 1.0f;
        }
        return (int)amount;
    }

    protected int combinedArmorDisplay(EntityPlayer player, ItemStack legs) {
        boolean minimum;
        ItemStack[] armors = new ItemStack[]{player.getCurrentArmor(3), player.getCurrentArmor(2), legs, player.getCurrentArmor(0)};
        int types = 0;
        int max = 0;
        int damage = 0;
        boolean anyAlive = false;
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = armors[i];
            if (stack == null || !stack.hasTagCompound()) continue;
            NBTTagCompound armorTag = stack.getTagCompound().getCompoundTag(this.getBaseTagName());
            if (!(stack.getItem() instanceof ArmorCore)) continue;
            ++types;
            max += armorTag.getInteger("TotalDurability");
            if (armorTag.getBoolean("Broken")) {
                damage += armorTag.getInteger("TotalDurability");
                continue;
            }
            damage += armorTag.getInteger("Damage");
            anyAlive = true;
        }
        float ratio = ((float)max - (float)damage) / (float)max * (float)(types * 5) + 0.1f;
        boolean bl = minimum = anyAlive;
        if (ratio < (float)minimum) {
            ratio = (float)minimum;
        }
        return (int)ratio;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack armor, DamageSource source, int damage, int slot) {
        NBTTagCompound tags;
        if (armor.hasTagCompound() && !(tags = armor.getTagCompound().getCompoundTag(this.getBaseTagName())).getBoolean("Broken")) {
            int maxDurability = tags.getInteger("TotalDurability");
            int currentDurability = tags.getInteger("Damage");
            if (currentDurability + damage > maxDurability) {
                tags.setInteger("Damage", 0);
                tags.setBoolean("Broken", true);
                armor.setItemDamage(0);
                entity.worldObj.playSound(entity.posX, entity.posY, entity.posZ, "random.break", 1.0f, 1.0f, true);
            } else {
                tags.setInteger("Damage", currentDurability + damage);
                armor.setItemDamage(currentDurability + damage);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(this.getDefaultItem());
    }

    public ItemStack getDefaultItem() {
        ItemStack gear = new ItemStack((Item)this, 1, 0);
        NBTTagCompound baseTag = new NBTTagCompound();
        NBTTagCompound tag = new NBTTagCompound();
        tag.setInteger("Modifiers", 3);
        double flat = this.getFlatDefense();
        double base = this.getBaseDefense();
        double max = this.getMaxDefense();
        tag.setDouble("DamageReduction", flat);
        tag.setDouble("BaseDefense", base);
        tag.setDouble("MaxDefense", max);
        int baseDurability = this.getDurability();
        tag.setInteger("Damage", 0);
        tag.setInteger("TotalDurability", baseDurability);
        tag.setInteger("BaseDurability", baseDurability);
        tag.setInteger("BonusDurability", 0);
        tag.setFloat("ModDurability", 0.0f);
        tag.setBoolean("Broken", false);
        tag.setBoolean("Built", true);
        baseTag.setTag(this.getBaseTagName(), (NBTBase)tag);
        gear.setTagCompound(baseTag);
        return gear;
    }

    protected double getFlatDefense() {
        return 0.0;
    }

    protected abstract double getBaseDefense();

    protected abstract double getMaxDefense();

    protected abstract int getDurability();

    public boolean isItemTool(ItemStack par1ItemStack) {
        return false;
    }

    public boolean getIsRepairable(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public int getItemEnchantability() {
        return 0;
    }

    public boolean isFull3D() {
        return true;
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return this.armorPart.getPartId() == armorType;
    }

    public int getItemMaxDamageFromStack(ItemStack stack) {
        NBTTagCompound tags = stack.getTagCompound();
        if (tags == null) {
            return 0;
        }
        return tags.getCompoundTag(this.getBaseTagName()).getInteger("TotalDurability");
    }

    public int getItemMaxDamageFromStackForDisplay(ItemStack stack) {
        NBTTagCompound tags = stack.getTagCompound();
        if (tags == null) {
            return 0;
        }
        return tags.getCompoundTag(this.getBaseTagName()).getInteger("Damage");
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (!stack.hasTagCompound()) {
            return;
        }
        NBTTagCompound tags = stack.getTagCompound().getCompoundTag(this.getBaseTagName());
        double protection = 0.0;
        if (!tags.getBoolean("Broken")) {
            protection = this.getProtection(tags);
        }
        if (protection > 0.0) {
            list.add("\u00a77" + StatCollector.translateToLocal((String)"armor.core.protection") + this.df.format(protection) + "%");
        } else {
            list.add("\u00a7o" + StatCollector.translateToLocal((String)"armor.core.broken"));
        }
        boolean displayToolTips = true;
        int tipNum = 0;
        while (displayToolTips) {
            String tooltip = "Tooltip" + ++tipNum;
            if (tags.hasKey(tooltip)) {
                String tipName = tags.getString(tooltip);
                String locString = "modifier.tooltip." + EnumChatFormatting.getTextWithoutFormattingCodes((String)tipName);
                if (StatCollector.canTranslate((String)(locString = locString.replace(" ", "")))) {
                    tipName = tipName.replace(EnumChatFormatting.getTextWithoutFormattingCodes((String)tipName), StatCollector.translateToLocal((String)locString));
                }
                if (tipName.equals("")) continue;
                list.add(tipName);
                continue;
            }
            displayToolTips = false;
        }
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new FancyEntityItem(world, location, itemstack);
    }
}

