/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.accessory;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.accessory.IAccessory;
import tconstruct.library.modifier.IModifyable;
import tconstruct.library.tools.ToolCore;

public abstract class AccessoryCore
extends Item
implements IAccessory,
IModifyable {
    protected String texture;
    static final String[] traits = new String[]{"accessory"};
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] modifiers;

    public AccessoryCore(String texture) {
        this.setCreativeTab(TConstructRegistry.equipableTab);
        this.setMaxStackSize(1);
        this.texture = texture;
    }

    @Override
    public String getBaseTagName() {
        return "TinkerAccessory";
    }

    @Override
    public String getModifyType() {
        return "Accessory";
    }

    @Override
    public String[] getTraits() {
        return traits;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(this.getDefaultItem());
    }

    public ItemStack getDefaultItem() {
        ItemStack gear = new ItemStack((Item)this, 1, 0);
        NBTTagCompound itemTag = new NBTTagCompound();
        int baseDurability = 500;
        itemTag.setInteger("Damage", 0);
        itemTag.setInteger("TotalDurability", baseDurability);
        itemTag.setInteger("BaseDurability", baseDurability);
        itemTag.setInteger("BonusDurability", 0);
        itemTag.setFloat("ModDurability", 0.0f);
        itemTag.setInteger("Modifiers", 5);
        itemTag.setBoolean("Broken", false);
        itemTag.setBoolean("Built", true);
        NBTTagCompound baseTag = new NBTTagCompound();
        baseTag.setTag(this.getBaseTagName(), (NBTBase)itemTag);
        gear.setTagCompound(baseTag);
        return gear;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("tinker:" + this.texture);
        this.registerModifiers(iconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerModifiers(IIconRegister iconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 4;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack par1ItemStack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        if (renderPass > 0) {
            if (stack.hasTagCompound()) {
                NBTTagCompound tags = stack.getTagCompound().getCompoundTag("TinkerAccessory");
                if (renderPass == 1 && tags.hasKey("Effect1")) {
                    return this.modifiers[tags.getInteger("Effect1")];
                }
                if (renderPass == 2 && tags.hasKey("Effect2")) {
                    return this.modifiers[tags.getInteger("Effect2")];
                }
                if (renderPass == 3 && tags.hasKey("Effect3")) {
                    return this.modifiers[tags.getInteger("Effect3")];
                }
            }
            return ToolCore.blankSprite;
        }
        return this.itemIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (!stack.hasTagCompound()) {
            return;
        }
        NBTTagCompound tags = stack.getTagCompound();
        if (tags.hasKey(this.getBaseTagName())) {
            tags = stack.getTagCompound().getCompoundTag(this.getBaseTagName());
            boolean broken = tags.getBoolean("Broken");
            if (broken) {
                list.add("\u00a7oBroken");
            } else {
                boolean displayToolTips = true;
                int tipNum = 0;
                while (displayToolTips) {
                    String tooltip = "Tooltip" + ++tipNum;
                    if (tags.hasKey(tooltip)) {
                        String tipName = tags.getString(tooltip);
                        if (tipName.equals("")) continue;
                        list.add(tipName);
                        continue;
                    }
                    displayToolTips = false;
                }
            }
        }
    }
}

