/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.items.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tconstruct.items.tools.BowBase;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.BowstringMaterial;
import tconstruct.library.tools.CustomMaterial;
import tconstruct.tools.TinkerTools;
import tconstruct.weaponry.TinkerWeaponry;

@Deprecated
public class Shortbow
extends BowBase {
    public Shortbow() {
        this.setUnlocalizedName("InfiTool.Shortbow");
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_bow_top";
            }
            case 1: {
                return "_bowstring_broken";
            }
            case 2: {
                return "_bowstring";
            }
            case 3: {
                return "_bow_bottom";
            }
        }
        return "";
    }

    @Override
    protected int getDefaultColor(int renderPass, int materialID) {
        CustomMaterial mat;
        if (renderPass == 0 && (mat = TConstructRegistry.getCustomMaterial(materialID, BowstringMaterial.class)) != null) {
            return mat.color;
        }
        return super.getDefaultColor(renderPass, materialID);
    }

    @Override
    public String getEffectSuffix() {
        return "_bow_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "shortbow";
    }

    @Override
    public Item getHeadItem() {
        return TinkerTools.toolRod;
    }

    @Override
    public Item getHandleItem() {
        return TinkerWeaponry.bowstring;
    }

    @Override
    public Item getAccessoryItem() {
        return TinkerTools.toolRod;
    }

    @Override
    public String[] getTraits() {
        return new String[]{"weapon", "ranged", "bow"};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onUpdate(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        EntityPlayerSP player;
        ItemStack usingItem;
        super.onUpdate(stack, world, entity, par4, par5);
        if (entity instanceof EntityPlayerSP && (usingItem = (player = (EntityPlayerSP)entity).getItemInUse()) != null && usingItem.getItem() == this) {
            player.movementInput.moveForward *= 2.0f;
            player.movementInput.moveStrafe *= 2.0f;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (!stack.hasTagCompound()) {
            return;
        }
        NBTTagCompound tags = stack.getTagCompound();
        if (tags.hasKey("Energy")) {
            String color = "";
            int power = tags.getInteger("Energy");
            if (power != 0) {
                color = power <= this.getMaxEnergyStored(stack) / 3 ? "\u00a74" : (power > this.getMaxEnergyStored(stack) * 2 / 3 ? "\u00a72" : "\u00a76");
            }
            String energy = color + tags.getInteger("Energy") + "/" + this.getMaxEnergyStored(stack) + " RF";
            list.add(energy);
        }
        if (tags.hasKey("InfiTool")) {
            boolean broken = tags.getCompoundTag("InfiTool").getBoolean("Broken");
            if (broken) {
                list.add("\u00a7oBroken");
            } else {
                int unbreaking;
                String reinforced;
                String extraName;
                String bindingName;
                String handleName;
                int head = tags.getCompoundTag("InfiTool").getInteger("Head");
                int handle = tags.getCompoundTag("InfiTool").getInteger("Handle");
                int binding = tags.getCompoundTag("InfiTool").getInteger("Accessory");
                int extra = tags.getCompoundTag("InfiTool").getInteger("Extra");
                String headName = this.getAbilityNameForType(head, 0);
                if (!headName.equals("")) {
                    list.add(Shortbow.getStyleForType(head) + headName);
                }
                if (!(handleName = this.getBowstringName(handle)).equals("") && handle != head) {
                    list.add(handleName);
                }
                if (this.getPartAmount() >= 3 && !(bindingName = this.getAbilityNameForType(binding, 0)).equals("") && binding != head && binding != handle) {
                    list.add(Shortbow.getStyleForType(binding) + bindingName);
                }
                if (this.getPartAmount() >= 4 && !(extraName = this.getAbilityNameForType(extra, 0)).equals("") && extra != head && extra != handle && extra != binding) {
                    list.add(Shortbow.getStyleForType(extra) + extraName);
                }
                if (!(reinforced = this.getReinforcedName(head, handle, binding, extra, unbreaking = tags.getCompoundTag("InfiTool").getInteger("Unbreaking"))).equals("")) {
                    list.add(reinforced);
                }
                boolean displayToolTips = true;
                int tipNum = 0;
                while (displayToolTips) {
                    String tooltip = "Tooltip" + ++tipNum;
                    if (tags.getCompoundTag("InfiTool").hasKey(tooltip)) {
                        String tipName = tags.getCompoundTag("InfiTool").getString(tooltip);
                        if (tipName.equals("")) continue;
                        list.add(tipName);
                        continue;
                    }
                    displayToolTips = false;
                }
            }
        }
        list.add("");
        list.add("\u00a79+" + tags.getCompoundTag("InfiTool").getInteger("Attack") + " " + StatCollector.translateToLocalFormatted((String)"attribute.name.generic.attackDamage", (Object[])new Object[0]));
    }

    public String getBowstringName(int type) {
        switch (type) {
            case 0: {
                return "";
            }
            case 1: {
                return "\u00a7bEnchanted";
            }
        }
        return "";
    }
}

