/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.items.tools;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.stats.StatList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.Weapon;
import tconstruct.tools.TinkerTools;

public class Scythe
extends Weapon {
    static Material[] materials = new Material[]{Material.web, Material.cactus, Material.plants, Material.leaves, Material.vine, Material.gourd};

    public Scythe() {
        super(4);
        this.setUnlocalizedName("InfiTool.Scythe");
    }

    @Override
    protected Material[] getEffectiveMaterials() {
        return materials;
    }

    @Override
    public Item getHeadItem() {
        return TinkerTools.scytheBlade;
    }

    @Override
    public Item getHandleItem() {
        return TinkerTools.toughRod;
    }

    @Override
    public Item getAccessoryItem() {
        return TinkerTools.toughBinding;
    }

    @Override
    public Item getExtraItem() {
        return TinkerTools.toughRod;
    }

    @Override
    public int getPartAmount() {
        return 4;
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_scythe_head";
            }
            case 1: {
                return "_scythe_head_broken";
            }
            case 2: {
                return "_scythe_handle";
            }
            case 3: {
                return "_scythe_binding";
            }
            case 4: {
                return "_scythe_accessory";
            }
        }
        return "";
    }

    @Override
    public float getDurabilityModifier() {
        return 3.0f;
    }

    @Override
    public float getRepairCost() {
        return 4.0f;
    }

    @Override
    public String getEffectSuffix() {
        return "_scythe_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "scythe";
    }

    @Override
    public int durabilityTypeAccessory() {
        return 1;
    }

    @Override
    public int durabilityTypeExtra() {
        return 1;
    }

    @Override
    public float getDamageModifier() {
        return 0.75f;
    }

    @Override
    public String[] getTraits() {
        return new String[]{"weapon", "melee", "harvest"};
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        if (!stack.hasTagCompound()) {
            return false;
        }
        World world = player.worldObj;
        Block blockB = world.getBlock(x, y, z);
        int meta = world.getBlockMetadata(x, y, z);
        if (!stack.hasTagCompound()) {
            return false;
        }
        NBTTagCompound tags = stack.getTagCompound().getCompoundTag("InfiTool");
        boolean butter = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.silkTouch.effectId, (ItemStack)stack) > 0;
        int fortune = EnchantmentHelper.getFortuneModifier((EntityLivingBase)player);
        for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int yPos = y - 1; yPos <= y + 1; ++yPos) {
                for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                    float localHardness;
                    if (tags.getBoolean("Broken")) continue;
                    boolean cancelHarvest = false;
                    for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                        if (!mod.beforeBlockBreak(this, stack, xPos, yPos, zPos, (EntityLivingBase)player)) continue;
                        cancelHarvest = true;
                    }
                    if (cancelHarvest) continue;
                    Block localBlock = world.getBlock(xPos, yPos, zPos);
                    int localMeta = world.getBlockMetadata(xPos, yPos, zPos);
                    float f = localHardness = localBlock == null ? Float.MAX_VALUE : localBlock.getBlockHardness(world, xPos, yPos, zPos);
                    if (localBlock == null) continue;
                    for (int iter = 0; iter < materials.length; ++iter) {
                        if (materials[iter] != localBlock.getMaterial()) continue;
                        if (!player.capabilities.isCreativeMode) {
                            INetHandler handler;
                            if (butter && localBlock instanceof IShearable && ((IShearable)localBlock).isShearable(stack, (IBlockAccess)player.worldObj, xPos, yPos, zPos)) {
                                ArrayList drops = ((IShearable)localBlock).onSheared(stack, (IBlockAccess)player.worldObj, xPos, yPos, zPos, EnchantmentHelper.getEnchantmentLevel((int)Enchantment.fortune.effectId, (ItemStack)stack));
                                Random rand = new Random();
                                if (!world.isRemote) {
                                    for (ItemStack dropStack : drops) {
                                        float f2 = 0.7f;
                                        double d = (double)(rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
                                        double d1 = (double)(rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
                                        double d2 = (double)(rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
                                        EntityItem entityitem = new EntityItem(player.worldObj, (double)xPos + d, (double)yPos + d1, (double)zPos + d2, dropStack);
                                        entityitem.delayBeforeCanPickup = 10;
                                        player.worldObj.spawnEntityInWorld((Entity)entityitem);
                                    }
                                }
                                if (localHardness > 0.0f) {
                                    this.onBlockDestroyed(stack, world, localBlock, xPos, yPos, zPos, (EntityLivingBase)player);
                                }
                                player.addStat(StatList.mineBlockStatArray[Block.getIdFromBlock((Block)localBlock)], 1);
                                world.setBlockToAir(xPos, yPos, zPos);
                                continue;
                            }
                            int exp = localBlock.getExpDrop((IBlockAccess)world, localMeta, fortune);
                            localBlock.onBlockHarvested(world, xPos, yPos, zPos, localMeta, player);
                            if (localBlock.removedByPlayer(world, player, xPos, yPos, zPos, true)) {
                                localBlock.onBlockDestroyedByPlayer(world, xPos, yPos, zPos, localMeta);
                                localBlock.harvestBlock(world, player, xPos, yPos, zPos, localMeta);
                                if (!butter) {
                                    localBlock.dropXpOnBlockBreak(world, xPos, yPos, zPos, exp);
                                }
                            }
                            if (world.isRemote && (handler = FMLClientHandler.instance().getClientPlayHandler()) != null && handler instanceof NetHandlerPlayClient) {
                                NetHandlerPlayClient handlerClient = (NetHandlerPlayClient)handler;
                                handlerClient.addToSendQueue((Packet)new C07PacketPlayerDigging(0, x, y, z, Minecraft.getMinecraft().objectMouseOver.sideHit));
                                handlerClient.addToSendQueue((Packet)new C07PacketPlayerDigging(2, x, y, z, Minecraft.getMinecraft().objectMouseOver.sideHit));
                            }
                            if (!(localHardness > 0.0f)) continue;
                            this.onBlockDestroyed(stack, world, localBlock, xPos, yPos, zPos, (EntityLivingBase)player);
                            continue;
                        }
                        world.setBlockToAir(xPos, yPos, zPos);
                    }
                }
            }
        }
        if (!world.isRemote) {
            world.playAuxSFX(2001, x, y, z, Block.getIdFromBlock((Block)blockB) + (meta << 12));
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        AxisAlignedBB box = AxisAlignedBB.getBoundingBox((double)entity.posX, (double)entity.posY, (double)entity.posZ, (double)(entity.posX + 1.0), (double)(entity.posY + 1.0), (double)(entity.posZ + 1.0)).expand(1.0, 1.0, 1.0);
        List list = player.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)player, box);
        for (Object o : list) {
            AbilityHelper.onLeftClickEntity(stack, (EntityLivingBase)player, (Entity)o, this);
        }
        return true;
    }
}

