/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.items.tools;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import gnu.trove.set.hash.THashSet;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import mantle.player.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.AOEHarvestTool;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.tools.TinkerTools;

public class LumberAxe
extends AOEHarvestTool {
    static Material[] materials = new Material[]{Material.wood, Material.vine, Material.circuits, Material.cactus, Material.gourd};

    public LumberAxe() {
        super(0, 1, 1);
        this.setUnlocalizedName("InfiTool.LumberAxe");
    }

    @Override
    protected Material[] getEffectiveMaterials() {
        return materials;
    }

    @Override
    protected String getHarvestType() {
        return "axe";
    }

    @Override
    public float getRepairCost() {
        return 4.0f;
    }

    @Override
    public float getDurabilityModifier() {
        return 2.5f;
    }

    @Override
    public boolean onBlockDestroyed(ItemStack itemstack, World world, Block block, int x, int y, int z, EntityLivingBase player) {
        if (block != null && block.getMaterial() == Material.leaves) {
            return false;
        }
        return AbilityHelper.onBlockChanged(itemstack, world, block, x, y, z, player, this.random);
    }

    @Override
    public float breakSpeedModifier() {
        return 0.4f;
    }

    @Override
    public float stoneboundModifier() {
        return 216.0f;
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        if (!stack.hasTagCompound() || player.isSneaking()) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        World world = player.worldObj;
        Block wood = world.getBlock(x, y, z);
        if (wood == null) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        if ((wood.isWood((IBlockAccess)world, x, y, z) || wood.getMaterial() == Material.sponge) && LumberAxe.detectTree(world, x, y, z)) {
            TreeChopTask chopper = new TreeChopTask(this, stack, new ChunkPosition(x, y, z), player, 128);
            try {
                FMLCommonHandler.instance().bus().register((Object)chopper);
            }
            catch (LinkageError l) {
                PlayerUtils.sendChatMessage((EntityPlayer)player, (String)"Well, that's embarrassing, you missed!");
                FMLLog.warning((String)"Unable to spawn TreeChopTask due to LinkageError", (Object[])new Object[0]);
            }
            return true;
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    public static boolean detectTree(World world, int pX, int pY, int pZ) {
        ChunkPosition pos = null;
        Stack<ChunkPosition> candidates = new Stack<ChunkPosition>();
        candidates.add(new ChunkPosition(pX, pY, pZ));
        while (!candidates.isEmpty()) {
            ChunkPosition candidate = (ChunkPosition)candidates.pop();
            int curX = candidate.chunkPosX;
            int curY = candidate.chunkPosY;
            int curZ = candidate.chunkPosZ;
            Block block = world.getBlock(curX, curY, curZ);
            if (pos != null && candidate.chunkPosY <= pos.chunkPosY || !block.isWood((IBlockAccess)world, curX, curY, curZ)) continue;
            pos = new ChunkPosition(curX, candidate.chunkPosY + 1, curZ);
            while (world.getBlock(curX, pos.chunkPosY, curZ).isWood((IBlockAccess)world, curX, pos.chunkPosY, curZ)) {
                pos = new ChunkPosition(curX, pos.chunkPosY + 1, curZ);
            }
            candidates.add(new ChunkPosition(curX + 1, pos.chunkPosY + 1, curZ));
            candidates.add(new ChunkPosition(curX, pos.chunkPosY + 1, curZ + 1));
            candidates.add(new ChunkPosition(curX - 1, pos.chunkPosY + 1, curZ));
            candidates.add(new ChunkPosition(curX, pos.chunkPosY + 1, curZ - 1));
        }
        if (pos == null) {
            return false;
        }
        int d = 3;
        int leaves = 0;
        for (int offX = 0; offX < d; ++offX) {
            for (int offY = 0; offY < d; ++offY) {
                for (int offZ = 0; offZ < d; ++offZ) {
                    int xPos = pos.chunkPosX - 1 + offX;
                    int yPos = pos.chunkPosY - 1 + offY;
                    int zPos = pos.chunkPosZ - 1 + offZ;
                    Block leaf = world.getBlock(xPos, yPos, zPos);
                    if (leaf == null || !leaf.isLeaves((IBlockAccess)world, xPos, yPos, zPos) || ++leaves < 5) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Item getHeadItem() {
        return TinkerTools.broadAxeHead;
    }

    @Override
    public Item getHandleItem() {
        return TinkerTools.toughRod;
    }

    @Override
    public Item getAccessoryItem() {
        return TinkerTools.largePlate;
    }

    @Override
    public Item getExtraItem() {
        return TinkerTools.toughBinding;
    }

    @Override
    public int getPartAmount() {
        return 4;
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_lumberaxe_head";
            }
            case 1: {
                return "_lumberaxe_head_broken";
            }
            case 2: {
                return "_lumberaxe_handle";
            }
            case 3: {
                return "_lumberaxe_shield";
            }
            case 4: {
                return "_lumberaxe_binding";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_lumberaxe_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "lumberaxe";
    }

    @Override
    public int durabilityTypeAccessory() {
        return 2;
    }

    @Override
    public int durabilityTypeExtra() {
        return 1;
    }

    public static class TreeChopTask {
        public final World world;
        public final EntityPlayer player;
        public final AOEHarvestTool tool;
        public final ItemStack stack;
        public final int blocksPerTick;
        public Queue<ChunkPosition> blocks = Lists.newLinkedList();
        public Set<ChunkPosition> visited = new THashSet();

        public TreeChopTask(AOEHarvestTool tool, ItemStack stack, ChunkPosition start, EntityPlayer player, int blocksPerTick) {
            this.world = player.getEntityWorld();
            this.player = player;
            this.tool = tool;
            this.stack = stack;
            this.blocksPerTick = blocksPerTick;
            this.blocks.add(start);
        }

        private void queueCoordinate(int x, int y, int z) {
            ChunkPosition pos = new ChunkPosition(x, y, z);
            if (!this.visited.contains(pos)) {
                this.blocks.add(pos);
            }
        }

        @SubscribeEvent
        public void onWorldTick(TickEvent.WorldTickEvent event) {
            if (event.side.isClient()) {
                this.finish();
                return;
            }
            if (event.world.provider.dimensionId != this.world.provider.dimensionId) {
                return;
            }
            int left = this.blocksPerTick;
            NBTTagCompound tags = this.stack.getTagCompound().getCompoundTag("InfiTool");
            while (left > 0) {
                if (this.blocks.isEmpty() || tags.getBoolean("Broken")) {
                    this.finish();
                    return;
                }
                ChunkPosition pos = this.blocks.remove();
                if (!this.visited.add(pos)) continue;
                int x = pos.chunkPosX;
                int y = pos.chunkPosY;
                int z = pos.chunkPosZ;
                Block block = this.world.getBlock(x, y, z);
                int meta = this.world.getBlockMetadata(x, y, z);
                if (!block.isWood((IBlockAccess)this.world, x, y, z) || !this.tool.isEffective(block, meta)) continue;
                this.queueCoordinate(x + 1, y, z);
                this.queueCoordinate(x, y, z + 1);
                this.queueCoordinate(x - 1, y, z);
                this.queueCoordinate(x, y, z - 1);
                for (int offX = 0; offX < 3; ++offX) {
                    for (int offZ = 0; offZ < 3; ++offZ) {
                        this.queueCoordinate(x - 1 + offX, y + 1, z - 1 + offZ);
                    }
                }
                boolean cancelHarvest = false;
                for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                    if (!mod.beforeBlockBreak(this.tool, this.stack, x, y, z, (EntityLivingBase)this.player)) continue;
                    cancelHarvest = true;
                }
                if (!cancelHarvest) {
                    this.tool.breakExtraBlock(this.player.worldObj, x, y, z, 0, this.player, x, y, z);
                }
                --left;
            }
        }

        private void finish() {
            FMLCommonHandler.instance().bus().unregister((Object)this);
        }
    }
}

