/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.client;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import tconstruct.TConstruct;
import tconstruct.library.tools.ToolCore;

public class FlexibleToolRenderer
implements IItemRenderer {
    public float depth = 0.03125f;
    private static final int toolIcons = 10;

    public void setDepth(float d) {
        this.depth = d;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        if (!item.hasTagCompound()) {
            return false;
        }
        switch (type) {
            case ENTITY: {
                return true;
            }
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                return true;
            }
            case INVENTORY: {
                return true;
            }
            default: {
                TConstruct.logger.warn("[TCon] Unhandled render case!");
            }
            case FIRST_PERSON_MAP: 
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return this.handleRenderType(item, type) & helper.ordinal() < IItemRenderer.ItemRendererHelper.EQUIPPED_BLOCK.ordinal();
    }

    protected void specialAnimation(IItemRenderer.ItemRenderType type, ItemStack item) {
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        float h;
        int k;
        int e;
        float d;
        float m;
        int i;
        float iconPos;
        int i2;
        if (item == null || item.getItem() == null || !(item.getItem() instanceof ToolCore)) {
            return;
        }
        Entity ent = null;
        if (data.length > 1) {
            ent = (Entity)data[1];
        }
        IIcon[] parts = new IIcon[10];
        int iconParts = this.getIcons(item, type, ent, parts);
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.renderInventory(iconParts, parts, item);
            return;
        }
        Tessellator tess = Tessellator.instance;
        float[] xMax = new float[iconParts];
        float[] yMin = new float[iconParts];
        float[] xMin = new float[iconParts];
        float[] yMax = new float[iconParts];
        float[] width = new float[iconParts];
        float[] height = new float[iconParts];
        float[] xDiff = new float[iconParts];
        float[] yDiff = new float[iconParts];
        float[] xSub = new float[iconParts];
        float[] ySub = new float[iconParts];
        for (int i3 = 0; i3 < iconParts; ++i3) {
            IIcon icon = parts[i3];
            xMin[i3] = icon.getMinU();
            xMax[i3] = icon.getMaxU();
            yMin[i3] = icon.getMinV();
            yMax[i3] = icon.getMaxV();
            width[i3] = icon.getIconWidth();
            height[i3] = icon.getIconHeight();
            xDiff[i3] = xMin[i3] - xMax[i3];
            yDiff[i3] = yMin[i3] - yMax[i3];
            xSub[i3] = 0.5f * (xMax[i3] - xMin[i3]) / width[i3];
            ySub[i3] = 0.5f * (yMax[i3] - yMin[i3]) / height[i3];
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        if (type != IItemRenderer.ItemRenderType.ENTITY) {
            this.specialAnimation(type, item);
        } else {
            GL11.glTranslatef((float)-0.5f, (float)-0.25f, (float)0.0f);
        }
        int[] color = new int[iconParts];
        for (i2 = 0; i2 < iconParts; ++i2) {
            color[i2] = item.getItem().getColorFromItemStack(item, i2);
        }
        tess.startDrawingQuads();
        tess.setNormal(0.0f, 0.0f, 1.0f);
        for (i2 = 0; i2 < iconParts; ++i2) {
            tess.setColorOpaque_I(color[i2]);
            tess.addVertexWithUV(0.0, 0.0, (double)this.depth, (double)xMax[i2], (double)yMax[i2]);
            tess.addVertexWithUV(1.0, 0.0, (double)this.depth, (double)xMin[i2], (double)yMax[i2]);
            tess.addVertexWithUV(1.0, 1.0, (double)this.depth, (double)xMin[i2], (double)yMin[i2]);
            tess.addVertexWithUV(0.0, 1.0, (double)this.depth, (double)xMax[i2], (double)yMin[i2]);
        }
        tess.draw();
        tess.startDrawingQuads();
        tess.setNormal(0.0f, 0.0f, -1.0f);
        for (i2 = 0; i2 < iconParts; ++i2) {
            tess.setColorOpaque_I(color[i2]);
            tess.addVertexWithUV(0.0, 1.0, (double)(-this.depth), (double)xMax[i2], (double)yMin[i2]);
            tess.addVertexWithUV(1.0, 1.0, (double)(-this.depth), (double)xMin[i2], (double)yMin[i2]);
            tess.addVertexWithUV(1.0, 0.0, (double)(-this.depth), (double)xMin[i2], (double)yMax[i2]);
            tess.addVertexWithUV(0.0, 0.0, (double)(-this.depth), (double)xMax[i2], (double)yMax[i2]);
        }
        tess.draw();
        tess.startDrawingQuads();
        tess.setNormal(-1.0f, 0.0f, 0.0f);
        for (int i4 = 0; i4 < iconParts; ++i4) {
            tess.setColorOpaque_I(color[i4]);
            float w = width[i4];
            float m2 = xMax[i4];
            float d2 = xDiff[i4];
            float s = xSub[i4];
            int e2 = (int)w;
            for (int k2 = 0; k2 < e2; ++k2) {
                float pos = (float)k2 / w;
                iconPos = m2 + d2 * pos - s;
                tess.addVertexWithUV((double)pos, 0.0, (double)(-this.depth), (double)iconPos, (double)yMax[i4]);
                tess.addVertexWithUV((double)pos, 0.0, (double)this.depth, (double)iconPos, (double)yMax[i4]);
                tess.addVertexWithUV((double)pos, 1.0, (double)this.depth, (double)iconPos, (double)yMin[i4]);
                tess.addVertexWithUV((double)pos, 1.0, (double)(-this.depth), (double)iconPos, (double)yMin[i4]);
            }
        }
        tess.draw();
        tess.startDrawingQuads();
        tess.setNormal(1.0f, 0.0f, 0.0f);
        for (i = 0; i < iconParts; ++i) {
            tess.setColorOpaque_I(color[i]);
            float w = width[i];
            m = xMax[i];
            d = xDiff[i];
            float s = xSub[i];
            float d2 = 1.0f / w;
            e = (int)w;
            for (k = 0; k < e; ++k) {
                float pos = (float)k / w;
                iconPos = m + d * pos - s;
                float posEnd = pos + d2;
                tess.addVertexWithUV((double)posEnd, 1.0, (double)(-this.depth), (double)iconPos, (double)yMin[i]);
                tess.addVertexWithUV((double)posEnd, 1.0, (double)this.depth, (double)iconPos, (double)yMin[i]);
                tess.addVertexWithUV((double)posEnd, 0.0, (double)this.depth, (double)iconPos, (double)yMax[i]);
                tess.addVertexWithUV((double)posEnd, 0.0, (double)(-this.depth), (double)iconPos, (double)yMax[i]);
            }
        }
        tess.draw();
        tess.startDrawingQuads();
        tess.setNormal(0.0f, 1.0f, 0.0f);
        for (i = 0; i < iconParts; ++i) {
            tess.setColorOpaque_I(color[i]);
            h = height[i];
            m = yMax[i];
            d = yDiff[i];
            float s = ySub[i];
            float d2 = 1.0f / h;
            e = (int)h;
            for (k = 0; k < e; ++k) {
                float pos = (float)k / h;
                iconPos = m + d * pos - s;
                float posEnd = pos + d2;
                tess.addVertexWithUV(0.0, (double)posEnd, (double)this.depth, (double)xMax[i], (double)iconPos);
                tess.addVertexWithUV(1.0, (double)posEnd, (double)this.depth, (double)xMin[i], (double)iconPos);
                tess.addVertexWithUV(1.0, (double)posEnd, (double)(-this.depth), (double)xMin[i], (double)iconPos);
                tess.addVertexWithUV(0.0, (double)posEnd, (double)(-this.depth), (double)xMax[i], (double)iconPos);
            }
        }
        tess.draw();
        tess.startDrawingQuads();
        tess.setNormal(0.0f, -1.0f, 0.0f);
        for (i = 0; i < iconParts; ++i) {
            tess.setColorOpaque_I(color[i]);
            h = height[i];
            m = yMax[i];
            d = yDiff[i];
            float s = ySub[i];
            int e3 = (int)h;
            for (int k3 = 0; k3 < e3; ++k3) {
                float pos = (float)k3 / h;
                iconPos = m + d * pos - s;
                tess.addVertexWithUV(1.0, (double)pos, (double)this.depth, (double)xMin[i], (double)iconPos);
                tess.addVertexWithUV(0.0, (double)pos, (double)this.depth, (double)xMax[i], (double)iconPos);
                tess.addVertexWithUV(0.0, (double)pos, (double)(-this.depth), (double)xMax[i], (double)iconPos);
                tess.addVertexWithUV(1.0, (double)pos, (double)(-this.depth), (double)xMin[i], (double)iconPos);
            }
        }
        tess.draw();
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public void renderInventory(int count, IIcon[] icons, ItemStack item) {
        Tessellator tess = Tessellator.instance;
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.5f);
        tess.startDrawingQuads();
        for (int i = 0; i < count; ++i) {
            tess.setColorOpaque_I(item.getItem().getColorFromItemStack(item, i));
            IIcon icon = icons[i];
            float xmin = icon.getMinU();
            float xmax = icon.getMaxU();
            float ymin = icon.getMinV();
            float ymax = icon.getMaxV();
            tess.addVertexWithUV(0.0, 16.0, 0.0, (double)xmin, (double)ymax);
            tess.addVertexWithUV(16.0, 16.0, 0.0, (double)xmax, (double)ymax);
            tess.addVertexWithUV(16.0, 0.0, 0.0, (double)xmax, (double)ymin);
            tess.addVertexWithUV(0.0, 0.0, 0.0, (double)xmin, (double)ymin);
        }
        tess.draw();
        GL11.glDisable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public int getIcons(ItemStack item, IItemRenderer.ItemRenderType type, Entity ent, IIcon[] parts) {
        EntityPlayer player;
        ItemStack itemInUse;
        int iconParts = 10;
        boolean isInventory = type == IItemRenderer.ItemRenderType.INVENTORY;
        ToolCore tool = (ToolCore)item.getItem();
        IIcon[] tempParts = new IIcon[iconParts];
        if (!isInventory && ent instanceof EntityPlayer && (itemInUse = (player = (EntityPlayer)ent).getItemInUse()) != null) {
            int useCount = player.getItemInUseCount();
            int i = iconParts;
            while (i-- > 0) {
                tempParts[i] = tool.getIcon(item, i, player, itemInUse, useCount);
            }
        } else {
            int i = iconParts;
            while (i-- > 0) {
                tempParts[i] = tool.getIcon(item, i);
            }
        }
        int count = 0;
        for (int i = 0; i < iconParts; ++i) {
            IIcon part = tempParts[i];
            if (part == null || part == ToolCore.blankSprite || part == ToolCore.emptyIcon) {
                ++count;
                continue;
            }
            parts[i - count] = part;
        }
        if ((iconParts -= count) <= 0) {
            iconParts = 1;
            parts[0] = ToolCore.blankSprite;
        }
        return iconParts;
    }
}

