/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.client;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import mantle.common.network.AbstractPacket;
import modwarriors.notenoughkeys.api.Api;
import modwarriors.notenoughkeys.api.KeyBindingPressedEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraftforge.client.event.MouseEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import tconstruct.TConstruct;
import tconstruct.armor.ArmorProxyClient;
import tconstruct.armor.PlayerAbilityHelper;
import tconstruct.armor.items.TravelGear;
import tconstruct.util.network.AccessoryInventoryPacket;
import tconstruct.util.network.BeltPacket;
import tconstruct.util.network.DoubleJumpPacket;
import tconstruct.util.network.GogglePacket;

public class ArmorControls {
    public static final String keybindCategory = "tconstruct.keybindings";
    public static final String[] keyDescs = new String[]{"key.tarmor", "key.tgoggles", "key.tbelt", "key.tzoom"};
    public static KeyBinding armorKey = new KeyBinding(keyDescs[0], 24, "tconstruct.keybindings");
    public static KeyBinding toggleGoggles = new KeyBinding(keyDescs[1], 34, "tconstruct.keybindings");
    public static KeyBinding beltSwap = new KeyBinding(keyDescs[2], 48, "tconstruct.keybindings");
    public static KeyBinding zoomKey = new KeyBinding(keyDescs[3], 44, "tconstruct.keybindings");
    static KeyBinding jumpKey;
    static KeyBinding invKey;
    static Minecraft mc;
    boolean jumping;
    int midairJumps = 0;
    boolean climbing = false;
    boolean onGround = false;
    public static boolean zoom;
    boolean activeGoggles = false;
    int currentTab = 1;
    private final KeyBinding[] keys;

    public ArmorControls() {
        ArmorControls.getVanillaKeyBindings();
        this.keys = new KeyBinding[]{armorKey, toggleGoggles, beltSwap, zoomKey, null, null};
    }

    public void registerKeys() {
        for (KeyBinding key : this.keys) {
            if (key == null) continue;
            ClientRegistry.registerKeyBinding((KeyBinding)key);
        }
        if (Loader.isModLoaded((String)"notenoughkeys")) {
            Api.registerMod((String)"TConstruct", (String[])keyDescs);
        }
        this.keys[4] = jumpKey;
        this.keys[5] = invKey;
    }

    private static KeyBinding[] getVanillaKeyBindings() {
        mc = Minecraft.getMinecraft();
        jumpKey = ArmorControls.mc.gameSettings.keyBindJump;
        invKey = ArmorControls.mc.gameSettings.keyBindInventory;
        return new KeyBinding[]{jumpKey, invKey};
    }

    @SubscribeEvent
    public void mouseEvent(MouseEvent event) {
        if (!Loader.isModLoaded((String)"notenoughkeys")) {
            this.checkKeys(event.button + 100);
        }
    }

    @SubscribeEvent
    public void keyEvent(InputEvent.KeyInputEvent event) {
        if (!Loader.isModLoaded((String)"notenoughkeys")) {
            this.checkKeys(-1);
        }
    }

    @Optional.Method(modid="notenoughkeys")
    @SubscribeEvent
    public void keyEventSpecial(KeyBindingPressedEvent event) {
        this.sendPress(event.keyBinding, event.isKeyBindingPressed);
    }

    private void checkKeys(int keycode) {
        for (KeyBinding key : this.keys) {
            if (keycode >= 0 && key.getKeyCode() != keycode) continue;
            this.checkKeyAndSendPress(key);
        }
    }

    private void checkKeyAndSendPress(KeyBinding key) {
        this.sendPress(key, this.isKeyActive(key.getKeyCode()));
    }

    private void sendPress(KeyBinding key, boolean isPressed) {
        if (isPressed) {
            this.keyPressed(key);
        }
    }

    private boolean isKeyActive(int keyCode) {
        if (keyCode < 0) {
            return Mouse.isButtonDown((int)(keyCode + 100));
        }
        return Keyboard.isKeyDown((int)keyCode);
    }

    private void keyPressed(KeyBinding key) {
        if (key == armorKey) {
            ArmorControls.openArmorGui();
        }
        if (key == jumpKey) {
            if (ArmorControls.mc.thePlayer.capabilities.isCreativeMode) {
                return;
            }
            if (this.jumping && this.midairJumps > 0) {
                ArmorControls.mc.thePlayer.motionY = 0.42;
                ArmorControls.mc.thePlayer.fallDistance = 0.0f;
                if (ArmorControls.mc.thePlayer.isPotionActive(Potion.jump)) {
                    ArmorControls.mc.thePlayer.motionY += (double)((float)(ArmorControls.mc.thePlayer.getActivePotionEffect(Potion.jump).getAmplifier() + 1) * 0.1f);
                }
                --this.midairJumps;
                this.resetFallDamage();
            }
            if (!this.jumping) {
                ItemStack wings;
                this.jumping = ArmorControls.mc.thePlayer.isAirBorne;
                ItemStack shoes = ArmorControls.mc.thePlayer.getCurrentArmor(0);
                if (shoes != null && shoes.hasTagCompound() && shoes.getTagCompound().hasKey("TinkerArmor")) {
                    NBTTagCompound shoeTag = shoes.getTagCompound().getCompoundTag("TinkerArmor");
                    this.midairJumps += shoeTag.getInteger("Double-Jump");
                }
                if ((wings = ArmorControls.mc.thePlayer.getCurrentArmor(1)) != null && wings.hasTagCompound() && wings.getTagCompound().hasKey("TinkerArmor")) {
                    NBTTagCompound shoeTag = wings.getTagCompound().getCompoundTag("TinkerArmor");
                    this.midairJumps += shoeTag.getInteger("Double-Jump");
                }
            }
        }
        if (ArmorControls.mc.currentScreen == null) {
            ItemStack goggles;
            if (key == toggleGoggles && (goggles = ArmorControls.mc.thePlayer.getCurrentArmor(3)) != null && goggles.getItem() instanceof TravelGear && goggles.hasTagCompound() && goggles.getTagCompound().getCompoundTag(((TravelGear)goggles.getItem()).getBaseTagName()).getBoolean("Night Vision")) {
                this.activeGoggles = !this.activeGoggles;
                PlayerAbilityHelper.toggleGoggles((EntityPlayer)ArmorControls.mc.thePlayer, this.activeGoggles);
                this.toggleGoggles();
            }
            if (key == beltSwap && ArmorProxyClient.armorExtended.inventory[3] != null) {
                PlayerAbilityHelper.swapBelt((EntityPlayer)ArmorControls.mc.thePlayer, ArmorProxyClient.armorExtended);
                this.toggleBelt();
            }
            if (key == zoomKey) {
                zoom = !zoom;
            }
        }
    }

    public void landOnGround() {
        this.midairJumps = 0;
        this.jumping = false;
    }

    public void resetControls() {
        this.midairJumps = 0;
        this.jumping = false;
        this.climbing = false;
        this.onGround = false;
    }

    void resetFallDamage() {
        DoubleJumpPacket packet = new DoubleJumpPacket();
        ArmorControls.updateServer(packet);
    }

    public static void openArmorGui() {
        AccessoryInventoryPacket packet = new AccessoryInventoryPacket(101);
        ArmorControls.updateServer(packet);
    }

    public static void openKnapsackGui() {
        AccessoryInventoryPacket packet = new AccessoryInventoryPacket(102);
        ArmorControls.updateServer(packet);
    }

    private void toggleGoggles() {
        GogglePacket packet = new GogglePacket(this.activeGoggles);
        ArmorControls.updateServer(packet);
    }

    private void toggleBelt() {
        BeltPacket packet = new BeltPacket();
        ArmorControls.updateServer(packet);
    }

    static void updateServer(AbstractPacket abstractPacket) {
        TConstruct.packetPipeline.sendToServer(abstractPacket);
    }

    static {
        zoom = false;
    }
}

