/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks.slime;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import tconstruct.library.TConstructRegistry;

public class SlimeTallGrass
extends BlockBush
implements IShearable {
    private static final String[] grassTypes = new String[]{"slimegrass_blue_tall"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public SlimeTallGrass() {
        super(Material.vine);
        float f = 0.4f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.8f, 0.5f + f);
        this.setCreativeTab(TConstructRegistry.blockTab);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        meta = MathHelper.clamp_int((int)meta, (int)0, (int)(this.iconArray.length - 1));
        return this.iconArray[meta];
    }

    public int idDropped(int par1, Random par2Random, int par3) {
        return -1;
    }

    public int quantityDroppedWithBonus(int par1, Random par2Random) {
        return 1 + par2Random.nextInt(par1 * 2 + 1);
    }

    public int getDamageValue(World par1World, int par2, int par3, int par4) {
        return par1World.getBlockMetadata(par2, par3, par4);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Block b, CreativeTabs par2CreativeTabs, List par3List) {
        for (int j = 0; j < 1; ++j) {
            par3List.add(new ItemStack(b, 1, j));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.iconArray = new IIcon[grassTypes.length];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = par1IconRegister.registerIcon("tinker:" + grassTypes[i]);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (world.rand.nextInt(8) != 0) {
            return ret;
        }
        ItemStack item = ForgeHooks.getGrassSeed((World)world);
        if (item != null) {
            ret.add(item);
        }
        return ret;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, world.getBlockMetadata(x, y, z)));
        return ret;
    }
}

