/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks.slime;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import tconstruct.library.TConstructRegistry;
import tconstruct.tools.TinkerTools;
import tconstruct.world.TinkerWorld;
import tconstruct.world.gen.SlimeTreeGen;

public class SlimeSapling
extends BlockSapling {
    public IIcon[] icons;
    public String[] textureNames = new String[]{"blue"};

    public SlimeSapling() {
        float f = 0.4f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
        this.setHardness(0.0f);
        this.setStepSound(Block.soundTypeGrass);
        this.setCreativeTab(TConstructRegistry.blockTab);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("tinker:slimesapling_" + this.textureNames[i]);
        }
    }

    public boolean canPlaceBlockOn(Block id) {
        return id == Blocks.grass || id == Blocks.dirt || id == TinkerWorld.slimeGrass || id == TinkerTools.craftedSoil;
    }

    public void updateTick(World world, int x, int y, int z, Random random) {
        if (world.isRemote) {
            return;
        }
        super.updateTick(world, x, y, z, random);
        int md = world.getBlockMetadata(x, y, z);
        if (random.nextInt(10) == 0 && world.getBlockLightValue(x, y + 1, z) >= 9) {
            if ((md & 8) == 0) {
                world.setBlockMetadataWithNotify(x, y, z, md | 8, 4);
            } else {
                this.growTree(world, x, y, z, random);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return this.icons[meta % this.icons.length];
    }

    public void func_149879_c(World world, int x, int y, int z, Random random) {
        this.boneFertilize(world, x, y, z, random, null);
    }

    public boolean boneFertilize(World world, int x, int y, int z, Random random, EntityPlayer player) {
        int meta = world.getBlockMetadata(x, y, z);
        if (!(meta % 8 != 0 || player != null && player.capabilities.isCreativeMode)) {
            return false;
        }
        if ((meta & 8) == 0) {
            world.setBlockMetadataWithNotify(x, y, z, meta | 8, 4);
        } else {
            this.growTree(world, x, y, z, random);
        }
        return true;
    }

    public void growTree(World world, int x, int y, int z, Random random) {
        int md = world.getBlockMetadata(x, y, z) % 8;
        world.setBlock(x, y, z, Blocks.air);
        SlimeTreeGen obj = null;
        obj = new SlimeTreeGen(true, 5, 4, 1, 0);
        if (!obj.generate(world, random, x, y, z)) {
            world.setBlock(x, y, z, (Block)this, md + 8, 3);
        }
    }

    public int damageDropped(int i) {
        return i % 8;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < 1; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }
}

