/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks.slime;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import tconstruct.world.TinkerWorld;
import tconstruct.world.entity.BlueSlime;
import tconstruct.world.entity.KingBlueSlime;
import tconstruct.world.entity.SlimeBase;

public class SlimeFluid
extends BlockFluidClassic {
    IIcon stillIcon;
    IIcon flowIcon;

    public SlimeFluid(Fluid fluid, Material material) {
        super(fluid, material);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.stillIcon = iconRegister.registerIcon("tinker:slime_blue");
        this.flowIcon = iconRegister.registerIcon("tinker:slime_blue_flow");
        TinkerWorld.blueSlimeFluid.setStillIcon(this.stillIcon);
        TinkerWorld.blueSlimeFluid.setFlowingIcon(this.flowIcon);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (side == 0 || side == 1) {
            return this.stillIcon;
        }
        return this.flowIcon;
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
        super.updateTick(world, x, y, z, rand);
        if (rand.nextInt(100) == 0 && world.getBlockMetadata(x, y, z) == 0 && world.checkNoEntityCollision(AxisAlignedBB.getBoundingBox((double)(x - 1), (double)(y - 1), (double)(z - 1), (double)(x + 2), (double)(y + 2), (double)(z + 2)))) {
            SlimeBase slime = rand.nextInt(300) == 0 ? new KingBlueSlime(world) : new BlueSlime(world);
            slime.setPosition((double)x + 0.5, (double)y + 1.5, (double)z + 0.5);
            world.spawnEntityInWorld((Entity)slime);
        }
    }

    public void getSubBlocks(int par1, CreativeTabs par2CreativeTabs, List par3List) {
    }
}

