/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mantle.blocks.MantleBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.library.TConstructRegistry;

public class SlabBase
extends MantleBlock {
    Block modelBlock;
    int startingMeta;
    int totalSize;

    public SlabBase(Material material) {
        super(material);
        this.setCreativeTab(TConstructRegistry.blockTab);
    }

    public SlabBase(Material material, Block model, int meta, int totalSize) {
        super(material);
        this.setCreativeTab(TConstructRegistry.blockTab);
        this.modelBlock = model;
        this.startingMeta = meta;
        this.totalSize = totalSize;
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, List arraylist, Entity entity) {
        this.setBlockBoundsBasedOnState((IBlockAccess)world, x, y, z);
        super.addCollisionBoxesToList(world, x, y, z, axisalignedbb, arraylist, entity);
    }

    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z) / 8;
        float minY = meta == 1 ? 0.5f : 0.0f;
        float maxY = meta == 1 ? 1.0f : 0.5f;
        this.setBlockBounds(0.0f, minY, 0.0f, 1.0f, maxY, 1.0f);
    }

    public int onBlockPlaced(World par1World, int blockX, int blockY, int blockZ, int side, float clickX, float clickY, float clickZ, int metadata) {
        if (side == 1) {
            return metadata;
        }
        if (side == 0 || clickY >= 0.5f) {
            return metadata | 8;
        }
        return metadata;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        meta = meta % 8 + this.startingMeta;
        return this.modelBlock.getIcon(side, meta);
    }

    public void getSubBlocks(Item id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < this.totalSize; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    public int damageDropped(int meta) {
        return meta % 8;
    }
}

