/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.armor.items;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tconstruct.armor.ArmorProxyClient;
import tconstruct.armor.TinkerArmor;
import tconstruct.client.ArmorControls;
import tconstruct.library.armor.ArmorCore;
import tconstruct.library.armor.ArmorPart;
import thaumcraft.api.IGoggles;
import thaumcraft.api.nodes.IRevealer;

@Optional.InterfaceList(value={@Optional.Interface(modid="Thaumcraft", iface="thaumcraft.api.nodes.IRevealer"), @Optional.Interface(modid="Thaumcraft", iface="thaumcraft.api.IGoggles")})
public class TravelGear
extends ArmorCore
implements IRevealer,
IGoggles {
    public TravelGear(ArmorPart part) {
        super(0, part, "Clothing", "travelgear", "travel");
        this.setMaxDamage(1035);
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        super.onArmorTick(world, player, itemStack);
        if (this.armorPart == ArmorPart.Chest && player.isInWater()) {
            player.motionX *= 1.2;
            if (player.motionY > 0.0) {
                player.motionY *= 1.2;
            }
            player.motionZ *= 1.2;
            double maxSpeed = 0.2;
            if (player.motionX > maxSpeed) {
                player.motionX = maxSpeed;
            } else if (player.motionX < -maxSpeed) {
                player.motionX = -maxSpeed;
            }
            if (player.motionY > maxSpeed) {
                player.motionY = maxSpeed;
            }
            if (player.motionZ > maxSpeed) {
                player.motionZ = maxSpeed;
            } else if (player.motionZ < -maxSpeed) {
                player.motionZ = -maxSpeed;
            }
        }
    }

    @Override
    protected double getBaseDefense() {
        switch (this.armorPart) {
            case Head: {
                return 0.0;
            }
            case Chest: {
                return 4.0;
            }
            case Legs: {
                return 2.0;
            }
            case Feet: {
                return 2.0;
            }
        }
        return 0.0;
    }

    @Override
    protected double getMaxDefense() {
        switch (this.armorPart) {
            case Head: {
                return 4.0;
            }
            case Chest: {
                return 10.0;
            }
            case Legs: {
                return 8.0;
            }
            case Feet: {
                return 6.0;
            }
        }
        return 0.0;
    }

    @Override
    protected int getDurability() {
        return 1035;
    }

    @Override
    public ItemStack getRepairMaterial(ItemStack input) {
        return new ItemStack(Items.leather);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("tinker:" + this.textureFolder + "/" + this.textureName + "_" + (this.armorType == 0 ? "goggles" : (this.armorType == 1 ? "vest" : (this.armorType == 2 ? "wings" : (this.armorType == 3 ? "boots" : "helmet")))));
        this.registerModifiers(iconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (armorSlot == 1) {
            return ArmorProxyClient.vest;
        }
        if (armorSlot == 2) {
            return ArmorProxyClient.wings;
        }
        if (armorSlot == 3) {
            return ArmorProxyClient.bootbump;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void registerModifiers(IIconRegister iconRegister) {
        switch (this.armorType) {
            case 0: {
                this.modifiers = new IIcon[5];
                this.modifiers[0] = iconRegister.registerIcon("tinker:" + this.textureFolder + "/goggles_nightvision");
                this.modifiers[1] = iconRegister.registerIcon("tinker:" + this.textureFolder + "/goggles_thaumic1");
                this.modifiers[2] = iconRegister.registerIcon("tinker:" + this.textureFolder + "/goggles_thaumic2");
                this.modifiers[4] = iconRegister.registerIcon("tinker:" + this.textureFolder + "/goggles_moss");
                break;
            }
            case 1: {
                this.modifiers = new IIcon[5];
                this.modifiers[0] = iconRegister.registerIcon("tinker:" + this.textureFolder + "/vest_dodge");
                this.modifiers[1] = iconRegister.registerIcon("tinker:" + this.textureFolder + "/vest_stealth");
                this.modifiers[4] = iconRegister.registerIcon("tinker:" + this.textureFolder + "/vest_moss");
                break;
            }
            case 2: {
                this.modifiers = new IIcon[5];
                this.modifiers[0] = iconRegister.registerIcon("tinker:" + this.textureFolder + "/wings_doublejump");
                this.modifiers[1] = iconRegister.registerIcon("tinker:" + this.textureFolder + "/wings_featherfall");
                this.modifiers[4] = iconRegister.registerIcon("tinker:" + this.textureFolder + "/wings_moss");
                break;
            }
            case 3: {
                this.modifiers = new IIcon[5];
                this.modifiers[0] = iconRegister.registerIcon("tinker:" + this.textureFolder + "/boots_doublejump");
                this.modifiers[1] = iconRegister.registerIcon("tinker:" + this.textureFolder + "/boots_waterwalk");
                this.modifiers[2] = iconRegister.registerIcon("tinker:" + this.textureFolder + "/boots_leadweight");
                this.modifiers[3] = iconRegister.registerIcon("tinker:" + this.textureFolder + "/boots_slimysole");
                this.modifiers[4] = iconRegister.registerIcon("tinker:" + this.textureFolder + "/boots_moss");
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        switch (this.armorPart) {
            case Head: {
                list.add("\u00a76" + StatCollector.translateToLocal((String)"armor.travelgoggles.ability") + GameSettings.getKeyDisplayString((int)ArmorControls.zoomKey.getKeyCode()));
                list.add("\u00a76" + StatCollector.translateToLocal((String)"armor.travelgoggles.toggleabilities") + GameSettings.getKeyDisplayString((int)ArmorControls.toggleGoggles.getKeyCode()));
                break;
            }
            case Chest: {
                list.add("\u00a76" + StatCollector.translateToLocal((String)"armor.travelvest.ability"));
                break;
            }
            case Legs: {
                list.add("\u00a76" + StatCollector.translateToLocal((String)"armor.travelwings.ability"));
                break;
            }
            case Feet: {
                list.add("\u00a76" + StatCollector.translateToLocal((String)"armor.travelboots.ability"));
                break;
            }
        }
        super.addInformation(stack, player, list, par4);
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showNodes(ItemStack itemstack, EntityLivingBase player) {
        if (itemstack == null || !itemstack.hasTagCompound() || itemstack.getItem() != TinkerArmor.travelGoggles) {
            return false;
        }
        return itemstack.getTagCompound().getCompoundTag(this.getBaseTagName()).getBoolean("Thaumic Senses");
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showIngamePopups(ItemStack itemstack, EntityLivingBase player) {
        if (itemstack == null || !itemstack.hasTagCompound() || itemstack.getItem() != TinkerArmor.travelGoggles) {
            return false;
        }
        return itemstack.getTagCompound().getCompoundTag(this.getBaseTagName()).getBoolean("Thaumic Vision");
    }
}

