/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.armor.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mantle.items.abstracts.CraftingItem;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tconstruct.armor.player.ArmorExtended;
import tconstruct.armor.player.TPlayerStats;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.accessory.IHealthAccessory;

public class HeartCanister
extends CraftingItem
implements IHealthAccessory {
    public HeartCanister() {
        super(new String[]{"empty", "miniheart.red", "red", "miniheart.yellow", "yellow", "miniheart.green", "green"}, new String[]{"canister_empty", "miniheart_red", "canister_red", "miniheart_yellow", "canister_yellow", "miniheart_green", "canister_green"}, "", "tinker", (CreativeTabs)TConstructRegistry.materialTab);
        this.setMaxStackSize(10);
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        TPlayerStats stats;
        int meta = stack.getItemDamage();
        if (meta == 1 || meta == 3 || meta == 5) {
            player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        }
        if (!world.isRemote && meta == 2 && (stats = TPlayerStats.get(player)) != null && stats.armor != null) {
            ArmorExtended armor = stats.armor;
            ItemStack slotStack = armor.getStackInSlot(6);
            if (slotStack == null) {
                armor.setInventorySlotContents(6, new ItemStack((Item)this, 1, 2));
                --stack.stackSize;
            } else if (slotStack.getItem() == this && slotStack.stackSize < this.maxStackSize) {
                ++slotStack.stackSize;
                --stack.stackSize;
            }
            armor.recalculateHealth(player, stats);
        }
        return stack;
    }

    public ItemStack onEaten(ItemStack stack, World world, EntityPlayer player) {
        int meta = stack.getItemDamage();
        --stack.stackSize;
        player.heal((float)((meta + 1) * 10));
        world.playSoundAtEntity((Entity)player, "random.burp", 0.5f, world.rand.nextFloat() * 0.1f + 0.9f);
        return stack;
    }

    public EnumAction getItemUseAction(ItemStack par1ItemStack) {
        return EnumAction.eat;
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 32;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        int meta = stack.getItemDamage();
        if (meta == 0 || meta % 2 == 1) {
            list.add(StatCollector.translateToLocal((String)"item.crafting.tooltip"));
        } else {
            list.add(StatCollector.translateToLocal((String)"item.accessory.tooltip"));
            list.add(StatCollector.translateToLocal((String)"canister.tooltip"));
        }
        switch (meta) {
            case 1: {
                list.add(StatCollector.translateToLocal((String)"canister.red.tooltip1"));
                list.add(StatCollector.translateToLocal((String)"canister.red.tooltip2"));
                break;
            }
            case 2: {
                list.add(StatCollector.translateToLocal((String)"canister.green.tooltip1"));
                list.add(StatCollector.translateToLocal((String)"canister.green.tooltip2"));
            }
        }
    }

    @Override
    public boolean canEquipAccessory(ItemStack item, int slot) {
        int type = item.getItemDamage();
        return type == 2 && slot == 6 || type == 4 && slot == 5 || type == 6 && slot == 4;
    }

    @Override
    public int getHealthBoost(ItemStack item) {
        return item.stackSize * 2;
    }
}

