/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.armor.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class DiamondApple
extends ItemFood {
    public IIcon[] icons;
    public String[] textureNames = new String[]{"food/apple_diamond"};
    public String[] itemNames = new String[]{"apple.diamond"};

    public DiamondApple() {
        super(4, 2.0f, false);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.setAlwaysEdible();
    }

    protected void onFoodEaten(ItemStack stack, World world, EntityPlayer player) {
        if (!world.isRemote) {
            int duration = 0;
            PotionEffect potion = player.getActivePotionEffect(Potion.resistance);
            if (potion != null) {
                duration = potion.getDuration();
            }
            player.addPotionEffect(new PotionEffect(Potion.field_76444_x.id, duration + 2400, 4));
            potion = player.getActivePotionEffect(Potion.resistance);
            if (potion != null) {
                duration = potion.getDuration();
            }
            player.addPotionEffect(new PotionEffect(Potion.resistance.id, duration + 1200, 0));
            potion = player.getActivePotionEffect(Potion.digSpeed);
            if (potion != null) {
                duration = potion.getDuration();
            }
            player.addPotionEffect(new PotionEffect(Potion.digSpeed.id, duration + 1200, 0));
            potion = player.getActivePotionEffect(Potion.damageBoost);
            if (potion != null) {
                duration = potion.getDuration();
            }
            player.addPotionEffect(new PotionEffect(Potion.damageBoost.id, duration + 1200, 0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int meta) {
        return this.icons[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("tinker:" + this.textureNames[i]);
        }
    }

    public String getUnlocalizedName(ItemStack itemstack) {
        return "item.food." + this.itemNames[itemstack.getItemDamage() >= this.itemNames.length || itemstack.getItemDamage() < 0 ? 0 : itemstack.getItemDamage()];
    }
}

