/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.armor;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Locale;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import tconstruct.TConstruct;
import tconstruct.armor.ArmorProxyClient;
import tconstruct.armor.TinkerArmor;
import tconstruct.armor.items.TravelWings;
import tconstruct.armor.player.TPlayerStats;
import tconstruct.library.modifier.IModifyable;
import tconstruct.util.config.PHConstruct;
import tconstruct.util.network.ArmourGuiSyncPacket;

public class TinkerArmorEvents {
    @SubscribeEvent
    public void onLivingDrop(LivingDropsEvent event) {
        if (event.entityLiving == null) {
            return;
        }
        if (!event.entityLiving.worldObj.getGameRules().getGameRuleBooleanValue("doMobLoot")) {
            return;
        }
        if (TConstruct.random.nextInt(200) == 0 && event.entityLiving instanceof IMob && event.source.damageType.equals("player")) {
            ItemStack dropStack = new ItemStack(TinkerArmor.heartCanister, 1, 1);
            EntityItem entityitem = new EntityItem(event.entityLiving.worldObj, event.entityLiving.posX, event.entityLiving.posY, event.entityLiving.posZ, dropStack);
            entityitem.delayBeforeCanPickup = 10;
            event.drops.add(entityitem);
        }
        if (event.entityLiving instanceof IBossDisplayData) {
            String entityName = event.entityLiving.getClass().getSimpleName().toLowerCase();
            for (String name : PHConstruct.heartDropBlacklist) {
                if (!name.toLowerCase(Locale.US).equals(entityName)) continue;
                return;
            }
            int count = event.entityLiving instanceof EntityDragon ? 5 : 1;
            for (int i = 0; i < count; ++i) {
                ItemStack dropStack = new ItemStack(TinkerArmor.heartCanister, 1, 3);
                EntityItem entityitem = new EntityItem(event.entityLiving.worldObj, event.entityLiving.posX, event.entityLiving.posY, event.entityLiving.posZ, dropStack);
                entityitem.delayBeforeCanPickup = 10;
                event.drops.add(entityitem);
            }
        }
    }

    @SubscribeEvent
    public void armorMineSpeed(PlayerEvent.BreakSpeed event) {
        if (event.entityPlayer == null) {
            return;
        }
        Object glove = TPlayerStats.get((EntityPlayer)event.entityPlayer).armor.getStackInSlot(1);
        if (event.entityPlayer.worldObj.isRemote) {
            glove = ArmorProxyClient.armorExtended != null ? ArmorProxyClient.armorExtended.getStackInSlot(1) : null;
        }
        if (glove == null || !glove.hasTagCompound()) {
            return;
        }
        NBTTagCompound tags = glove.getTagCompound().getCompoundTag(TinkerArmor.travelGlove.getBaseTagName());
        float mineSpeed = tags.getInteger("MiningSpeed");
        float modifier = 1.0f + mineSpeed / 1000.0f;
        float base = mineSpeed / 250.0f;
        event.newSpeed = (event.originalSpeed + base) * modifier;
    }

    @SubscribeEvent
    public void jumpHeight(LivingEvent.LivingJumpEvent event) {
        ItemStack stack = event.entityLiving.getEquipmentInSlot(2);
        if (stack != null && stack.getItem() instanceof TravelWings) {
            event.entityLiving.motionY += 0.2;
        }
    }

    @SubscribeEvent
    public void slimefall(LivingFallEvent event) {
        NBTTagCompound tag;
        int sole;
        ItemStack boots = event.entityLiving.getEquipmentInSlot(1);
        if (boots != null && boots.getItem() instanceof IModifyable && (sole = (tag = boots.getTagCompound().getCompoundTag(((IModifyable)boots.getItem()).getBaseTagName())).getInteger("Slimy Soles")) > 0) {
            event.distance /= (float)(1 + sole);
            event.entityLiving.fallDistance /= (float)(1 + sole);
        }
    }

    @SubscribeEvent
    public void perfectDodge(LivingAttackEvent event) {
        if (!event.source.isProjectile()) {
            return;
        }
        if (!(event.entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entityLiving;
        ItemStack chest = player.getCurrentArmor(2);
        if (chest == null || !(chest.getItem() instanceof IModifyable) || !chest.hasTagCompound()) {
            return;
        }
        NBTTagCompound tags = chest.getTagCompound().getCompoundTag(((IModifyable)chest.getItem()).getBaseTagName());
        int dodge = tags.getInteger("Perfect Dodge");
        if (dodge > TConstruct.random.nextInt(10)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void joinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.entity;
            TPlayerStats stats = TPlayerStats.get((EntityPlayer)player);
            NBTTagCompound tag = new NBTTagCompound();
            stats.saveNBTData(tag);
            ArmourGuiSyncPacket syncPacket = new ArmourGuiSyncPacket(tag);
            TConstruct.packetPipeline.sendTo(syncPacket, player);
        }
    }
}

