/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.armor;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import tconstruct.armor.player.ArmorExtended;
import tconstruct.armor.player.TPlayerStats;
import tconstruct.util.config.PHConstruct;

public class PlayerAbilityHelper {
    public static void toggleGoggles(EntityPlayer player, boolean active) {
        TPlayerStats stats = TPlayerStats.get(player);
        stats.activeGoggles = active;
        if (!stats.activeGoggles) {
            player.removePotionEffect(Potion.nightVision.id);
        } else {
            player.addPotionEffect(new PotionEffect(Potion.nightVision.id, 300, 0, true));
        }
    }

    public static boolean isDimensionAllowed(EntityPlayer player) {
        int currentDimID = player.worldObj.provider.dimensionId;
        for (int id : PHConstruct.cfgForbiddenDim) {
            if (id != currentDimID) continue;
            return false;
        }
        return true;
    }

    public static void swapBelt(EntityPlayer player, ArmorExtended armor) {
        if (!PlayerAbilityHelper.isDimensionAllowed(player)) {
            return;
        }
        NBTTagList slots = new NBTTagList();
        InventoryPlayer hotbar = player.inventory;
        ItemStack belt = armor.inventory[3];
        if (belt == null) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            if (hotbar.mainInventory[i] != null) {
                NBTTagCompound itemTag = new NBTTagCompound();
                itemTag.setByte("Slot", (byte)i);
                hotbar.mainInventory[i].writeToNBT(itemTag);
                slots.appendTag((NBTBase)itemTag);
            }
            hotbar.mainInventory[i] = null;
        }
        NBTTagList replaceSlots = belt.getTagCompound().getTagList("Inventory", 10);
        for (int i = 0; i < replaceSlots.tagCount(); ++i) {
            NBTTagCompound nbttagcompound = replaceSlots.getCompoundTagAt(i);
            int j = nbttagcompound.getByte("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound);
            if (itemstack == null || j < 0 || j >= hotbar.mainInventory.length) continue;
            hotbar.mainInventory[j] = itemstack;
        }
        belt.getTagCompound().setTag("Inventory", (NBTBase)slots);
    }

    public static void setEntitySize(Entity entity, float width, float height) {
        float f2;
        if (width != entity.width || height != entity.height) {
            f2 = entity.width;
            entity.width = width;
            entity.height = height;
            entity.boundingBox.maxX = entity.boundingBox.minX + (double)entity.width;
            entity.boundingBox.maxZ = entity.boundingBox.minZ + (double)entity.width;
            entity.boundingBox.maxY = entity.boundingBox.minY + (double)entity.height;
            if (entity.width > f2 && !entity.worldObj.isRemote) {
                entity.moveEntity((double)(f2 - entity.width), 0.0, (double)(f2 - entity.width));
            }
        }
        entity.myEntitySize = (double)(f2 = width % 2.0f) < 0.375 ? Entity.EnumEntitySize.SIZE_1 : ((double)f2 < 0.75 ? Entity.EnumEntitySize.SIZE_2 : ((double)f2 < 1.0 ? Entity.EnumEntitySize.SIZE_3 : ((double)f2 < 1.375 ? Entity.EnumEntitySize.SIZE_4 : ((double)f2 < 1.75 ? Entity.EnumEntitySize.SIZE_5 : Entity.EnumEntitySize.SIZE_6))));
    }
}

