/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.achievements;

import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.AchievementPage;
import tconstruct.smeltery.TinkerSmeltery;
import tconstruct.tools.TinkerTools;
import tconstruct.util.config.PHConstruct;

public class TAchievements {
    private static AchievementPage achievementsPage;
    private static HashMap<String, Achievement> achievementsList;

    public static void addAchievement(String name, Achievement achievement) {
        if (!PHConstruct.achievementsEnabled) {
            return;
        }
        achievementsList.put(name, achievement.registerStat());
    }

    public static Achievement getAchievement(String name) {
        return achievementsList.get(name);
    }

    public static void triggerAchievement(EntityPlayer player, String name) {
        if (!PHConstruct.achievementsEnabled) {
            return;
        }
        Achievement ach = TAchievements.getAchievement(name);
        if (ach != null) {
            player.triggerAchievement((StatBase)ach);
        }
    }

    public static void addDefaultAchievements() {
        if (!PHConstruct.achievementsEnabled) {
            return;
        }
        TAchievements.addAchievement("tconstruct.beginner", new Achievement("tconstruct.beginner", "tconstruct.beginner", 0, 0, TinkerTools.manualBook, null).initIndependentStat());
        TAchievements.addAchievement("tconstruct.pattern", new Achievement("tconstruct.pattern", "tconstruct.pattern", 2, 1, TinkerTools.blankPattern, TAchievements.getAchievement("tconstruct.beginner")));
        TAchievements.addAchievement("tconstruct.tinkerer", new Achievement("tconstruct.tinkerer", "tconstruct.tinkerer", 2, 2, new ItemStack(TinkerTools.titleIcon, 1, 4096), TAchievements.getAchievement("tconstruct.pattern")));
        TAchievements.addAchievement("tconstruct.preparedFight", new Achievement("tconstruct.preparedFight", "tconstruct.preparedFight", 1, 3, new ItemStack(TinkerTools.titleIcon, 1, 4097), TAchievements.getAchievement("tconstruct.tinkerer")));
        TAchievements.addAchievement("tconstruct.proTinkerer", new Achievement("tconstruct.proTinkerer", "tconstruct.proTinkerer", 4, 3, new ItemStack(TinkerTools.titleIcon, 1, 4098), TAchievements.getAchievement("tconstruct.tinkerer")));
        TAchievements.addAchievement("tconstruct.smelteryMaker", new Achievement("tconstruct.smelteryMaker", "tconstruct.smelteryMaker", -2, -1, TinkerSmeltery.smeltery, TAchievements.getAchievement("tconstruct.beginner")));
        TAchievements.addAchievement("tconstruct.enemySlayer", new Achievement("tconstruct.enemySlayer", "tconstruct.enemySlayer", 0, 5, new ItemStack(TinkerTools.titleIcon, 1, 4099), TAchievements.getAchievement("tconstruct.preparedFight")));
        TAchievements.addAchievement("tconstruct.dualConvenience", new Achievement("tconstruct.dualConvenience", "tconstruct.dualConvenience", 0, 7, new ItemStack(TinkerTools.titleIcon, 1, 4100), TAchievements.getAchievement("tconstruct.enemySlayer")).setSpecial());
    }

    public static void registerAchievementPane() {
        if (!PHConstruct.achievementsEnabled) {
            return;
        }
        Achievement[] achievements = new Achievement[achievementsList.size()];
        achievements = achievementsList.values().toArray(achievements);
        achievementsPage = new AchievementPage(StatCollector.translateToLocal((String)"tconstruct.achievementPage.name"), achievements);
        AchievementPage.registerAchievementPage((AchievementPage)achievementsPage);
    }

    static {
        achievementsList = new HashMap();
    }
}

