/*
 * Decompiled with CFR 0.152.
 */
package tehnut.resourceful.crops.util.handler;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import tehnut.resourceful.crops.ConfigHandler;
import tehnut.resourceful.crops.api.base.Seed;
import tehnut.resourceful.crops.api.registry.SeedRegistry;
import tehnut.resourceful.crops.registry.BlockRegistry;
import tehnut.resourceful.crops.registry.ItemRegistry;

public class OreDictHandler {
    public static void load() {
        OreDictHandler.registerSeeds();
        OreDictHandler.registerShards();
        if (ConfigHandler.enableSeedPouches) {
            OreDictHandler.registerPouches();
        }
        OreDictionary.registerOre((String)"oreGaianite", (ItemStack)new ItemStack(BlockRegistry.ore, 1, 0));
        OreDictionary.registerOre((String)"oreGaianite", (ItemStack)new ItemStack(BlockRegistry.ore, 1, 1));
    }

    private static void registerSeeds() {
        for (Seed seed : SeedRegistry.getSeedList()) {
            OreDictionary.registerOre((String)("rcropSeed" + seed.getName().replace(" ", "")), (ItemStack)new ItemStack((Item)ItemRegistry.seed, 1, SeedRegistry.getIndexOf(seed)));
        }
    }

    private static void registerShards() {
        for (Seed seed : SeedRegistry.getSeedList()) {
            OreDictionary.registerOre((String)("rcropShard" + seed.getName().replace(" ", "")), (ItemStack)new ItemStack(ItemRegistry.shard, 1, SeedRegistry.getIndexOf(seed)));
        }
    }

    private static void registerPouches() {
        for (Seed seed : SeedRegistry.getSeedList()) {
            OreDictionary.registerOre((String)("rcropPouch" + seed.getName().replace(" ", "")), (ItemStack)new ItemStack(ItemRegistry.pouch, 1, SeedRegistry.getIndexOf(seed)));
        }
    }
}

