/*
 * Decompiled with CFR 0.152.
 */
package tehnut.resourceful.crops.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import tehnut.resourceful.crops.ConfigHandler;
import tehnut.resourceful.crops.ResourcefulCrops;
import tehnut.resourceful.crops.achievement.AchievementTrigger;
import tehnut.resourceful.crops.api.ModInformation;
import tehnut.resourceful.crops.api.ResourcefulAPI;
import tehnut.resourceful.crops.api.base.Seed;
import tehnut.resourceful.crops.api.registry.SeedRegistry;
import tehnut.resourceful.crops.api.util.BlockStack;
import tehnut.resourceful.crops.registry.AchievementRegistry;
import tehnut.resourceful.crops.registry.BlockRegistry;
import tehnut.resourceful.crops.registry.ItemRegistry;
import tehnut.resourceful.crops.tile.TileRCrop;
import tehnut.resourceful.crops.util.ChatUtil;
import tehnut.resourceful.crops.util.Utils;

public class BlockRCrop
extends BlockCrops
implements ITileEntityProvider {
    public IIcon[] cropIcons = new IIcon[8];
    public IIcon[] fastIcons = new IIcon[8];
    public IIcon[] cropOverlay = new IIcon[8];

    public BlockRCrop() {
        this.func_149663_c("ResourcefulCrops.crop");
    }

    public static int getTileSeedIndex(World world, int x, int y, int z) {
        TileEntity crop = world.func_147438_o(x, y, z);
        int seedIndex = Utils.getInvalidSeed(ItemRegistry.seed).func_77960_j();
        if (crop != null && crop instanceof TileRCrop) {
            String seedName = ((TileRCrop)crop).getSeedName();
            seedIndex = SeedRegistry.getIndexOf(seedName);
        }
        return seedIndex;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        int seedIndex = BlockRCrop.getTileSeedIndex(world, x, y, z);
        Seed seed = SeedRegistry.getSeed(seedIndex);
        if (seedIndex == Short.MAX_VALUE) {
            return;
        }
        BlockStack blockReq = new BlockStack(world.func_147439_a(x, y - 2, z), world.func_72805_g(x, y - 2, z));
        this.func_149855_e(world, x, y, z);
        this.doGrowth(world, x, y, z, seed, blockReq, random);
    }

    public void doGrowth(World world, int x, int y, int z, Seed seed, BlockStack blockReq, Random random) {
        float growthChance;
        int meta;
        int lightLevel;
        if (seed.getSeedReq().getDifficulty().func_151525_a() > world.field_73013_u.func_151525_a()) {
            return;
        }
        if ((seed.getSeedReq().getGrowthReq() == null || seed.getSeedReq().getGrowthReq().equals(blockReq)) && (lightLevel = world.func_72957_l(x, y + 1, z)) >= seed.getSeedReq().getLightLevelMin() && lightLevel <= seed.getSeedReq().getLightLevelMax() && (meta = world.func_72805_g(x, y, z)) < 7 && random.nextInt((int)(25.0f / (growthChance = this.getGrowthChance(world, x, y, z))) + 1) == 0) {
            world.func_72921_c(x, y, z, ++meta, 2);
        }
    }

    private float getGrowthChance(World world, int x, int y, int z) {
        float growthChance = 1.0f;
        Block block = world.func_147439_a(x, y, z - 1);
        Block block1 = world.func_147439_a(x, y, z + 1);
        Block block2 = world.func_147439_a(x - 1, y, z);
        Block block3 = world.func_147439_a(x + 1, y, z);
        Block block4 = world.func_147439_a(x - 1, y, z - 1);
        Block block5 = world.func_147439_a(x + 1, y, z - 1);
        Block block6 = world.func_147439_a(x + 1, y, z + 1);
        Block block7 = world.func_147439_a(x - 1, y, z + 1);
        boolean flag = block2 == this || block3 == this;
        boolean flag1 = block == this || block1 == this;
        boolean flag2 = block4 == this || block5 == this || block6 == this || block7 == this;
        for (int coordX = x - 1; coordX <= x + 1; ++coordX) {
            for (int coordZ = z - 1; coordZ <= z + 1; ++coordZ) {
                float chance = 0.0f;
                if (world.func_147439_a(coordX, y - 1, coordZ).canSustainPlant((IBlockAccess)world, coordX, y - 1, coordZ, ForgeDirection.UP, (IPlantable)this)) {
                    chance = 1.0f;
                    if (world.func_147439_a(coordX, y - 1, coordZ).isFertile(world, coordX, y - 1, coordZ)) {
                        chance = 3.0f;
                    }
                }
                if (coordX != x || coordZ != z) {
                    chance /= 4.0f;
                }
                growthChance += chance;
            }
        }
        if (flag2 || flag && flag1) {
            growthChance /= 2.0f;
        }
        return growthChance;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity cropTile = world.func_147438_o(x, y, z);
        if (Utils.isValidSeed(((TileRCrop)cropTile).getSeedName())) {
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemHoe) {
                AchievementTrigger.triggerAchievement(player, AchievementRegistry.getInfo);
                return this.doReqInfo(((TileRCrop)cropTile).getSeedName());
            }
            if (!player.func_70093_af() || player.func_70694_bm() == null && ConfigHandler.enableRightClickHarvest) {
                AchievementTrigger.triggerAchievement(player, AchievementRegistry.getHarvest);
                return this.doHarvest(world, x, y, z, player);
            }
        }
        return false;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        this.dropItems(world, x, y, z, meta);
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public Item func_149650_a(int meta, Random random, int p_149650_3_) {
        return null;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        TileEntity crop = world.func_147438_o(x, y, z);
        if (crop != null && crop instanceof TileRCrop) {
            return new ItemStack((Item)ItemRegistry.seed, 1, BlockRCrop.getTileSeedIndex(world, x, y, z));
        }
        return Utils.getInvalidSeed(ItemRegistry.seed);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        for (int i = 0; i < this.cropIcons.length; ++i) {
            this.cropIcons[i] = ir.func_94245_a(ModInformation.TEXLOC + "crop_base_" + i);
            this.cropOverlay[i] = ir.func_94245_a(ModInformation.TEXLOC + "crop_overlay_" + i);
            this.fastIcons[i] = ir.func_94245_a(ModInformation.TEXLOC + "crop_base_" + i + "_fast");
        }
        this.field_149761_L = this.cropIcons[4];
        ResourcefulAPI.blockOverlay = this.cropOverlay;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return ConfigHandler.enableFancyRender || ConfigHandler.forceFancyRender ? this.cropIcons[meta] : this.fastIcons[meta];
    }

    public int func_149645_b() {
        return ConfigHandler.enableFancyRender || ConfigHandler.forceFancyRender ? ResourcefulCrops.renderIDCrop : 1;
    }

    public int func_149720_d(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity cropTile = blockAccess.func_147438_o(x, y, z);
        if (cropTile != null && cropTile instanceof TileRCrop && Utils.isValidSeed(((TileRCrop)cropTile).getSeedName()) && !ConfigHandler.enableFancyRender) {
            return SeedRegistry.getSeed(((TileRCrop)cropTile).getSeedName()).getColor().getRGB();
        }
        return 0xFFFFFF;
    }

    public void dropItems(World world, int x, int y, int z, int meta) {
        TileEntity cropTile = world.func_147438_o(x, y, z);
        if (cropTile instanceof TileRCrop && ((TileRCrop)cropTile).getShouldDrop()) {
            for (ItemStack stack : this.getDrops(world, x, y, z, meta)) {
                this.func_149642_a(world, x, y, z, stack);
            }
        }
    }

    public List<ItemStack> getDrops(World world, int x, int y, int z, int meta) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int seedIndex = BlockRCrop.getTileSeedIndex(world, x, y, z);
        double chance = new Random().nextDouble();
        Seed seed = SeedRegistry.getSeed(seedIndex);
        if (meta <= 6) {
            drops.add(new ItemStack((Item)ItemRegistry.seed, 1, seedIndex));
        } else {
            drops.add(new ItemStack((Item)ItemRegistry.seed, 1, seedIndex));
            drops.add(new ItemStack(ItemRegistry.shard, 1, seedIndex));
            if (chance <= seed.getChance().getExtraSeed()) {
                drops.add(new ItemStack((Item)ItemRegistry.seed, 1, seedIndex));
            }
            if (chance <= seed.getChance().getEssenceDrop()) {
                drops.add(new ItemStack(ItemRegistry.material));
            }
        }
        return drops;
    }

    public boolean doHarvest(World world, int x, int y, int z, EntityPlayer player) {
        if (world.func_147439_a(x, y, z) == BlockRegistry.crop && world.func_72805_g(x, y, z) >= 7) {
            if (!world.field_72995_K) {
                world.func_72921_c(x, y, z, 0, 3);
                this.doRightClickDrops(world, x, y, z);
            }
            player.func_71038_i();
            return true;
        }
        return false;
    }

    public boolean doReqInfo(String seedName) {
        Seed seed = SeedRegistry.getSeed(seedName);
        ArrayList<String> chatMsg = new ArrayList<String>();
        chatMsg.add(String.format(StatCollector.func_74838_a((String)"chat.ResourcefulCrops.req.growth"), seed.getSeedReq().getGrowthReq() != null ? seed.getSeedReq().getGrowthReq().getDisplayName() : StatCollector.func_74838_a((String)"info.ResourcefulCrops.anything")));
        if (seed.getSeedReq().getLightLevelMax() == Integer.MAX_VALUE) {
            chatMsg.add(String.format(StatCollector.func_74838_a((String)"chat.ResourcefulCrops.req.light.above"), seed.getSeedReq().getLightLevelMin()));
        } else if (seed.getSeedReq().getLightLevelMin() == 0) {
            chatMsg.add(String.format(StatCollector.func_74838_a((String)"chat.ResourcefulCrops.req.light.below"), seed.getSeedReq().getLightLevelMax()));
        } else {
            chatMsg.add(String.format(StatCollector.func_74838_a((String)"chat.ResourcefulCrops.req.light.between"), seed.getSeedReq().getLightLevelMin(), seed.getSeedReq().getLightLevelMax()));
        }
        if (seed.getSeedReq().getDifficulty() != EnumDifficulty.PEACEFUL) {
            chatMsg.add(String.format(StatCollector.func_74838_a((String)"chat.ResourcefulCrops.req.difficulty"), seed.getSeedReq().getDifficulty().toString()));
        }
        ChatUtil.sendNoSpamClient(chatMsg.toArray(new String[chatMsg.size()]));
        return true;
    }

    public void doRightClickDrops(World world, int x, int y, int z) {
        Random random = new Random();
        int seedIndex = BlockRCrop.getTileSeedIndex(world, x, y, z);
        Seed seed = SeedRegistry.getSeed(seedIndex);
        this.func_149642_a(world, x, y, z, new ItemStack(ItemRegistry.shard, 1, seedIndex));
        double extraSeedChance = seed.getChance().getExtraSeed();
        double essenceDropChance = seed.getChance().getEssenceDrop();
        double randomDouble = random.nextDouble();
        if (randomDouble <= extraSeedChance) {
            this.func_149642_a(world, x, y, z, new ItemStack((Item)ItemRegistry.seed, 1, seedIndex));
        }
        if (randomDouble <= essenceDropChance) {
            this.func_149642_a(world, x, y, z, new ItemStack(ItemRegistry.material));
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Crop;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileRCrop();
    }
}

