/*
 * Decompiled with CFR 0.152.
 */
package tehnut.resourceful.crops.item;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tehnut.resourceful.crops.ResourcefulCrops;
import tehnut.resourceful.crops.api.ModInformation;
import tehnut.resourceful.crops.api.base.Seed;
import tehnut.resourceful.crops.api.compat.CompatibilitySeed;
import tehnut.resourceful.crops.api.registry.SeedRegistry;
import tehnut.resourceful.crops.util.Utils;

public class ItemShard
extends Item {
    public ItemShard() {
        this.setUnlocalizedName("ResourcefulCrops.shard");
        this.setTextureName(ModInformation.TEXLOC + "shard_base");
        this.setCreativeTab(ResourcefulCrops.tabResourcefulCrops);
        this.setHasSubtypes(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tabs, List list) {
        for (Seed seed : SeedRegistry.getSeedList()) {
            list.add(new ItemStack((Item)this, 1, SeedRegistry.getIndexOf(seed)));
        }
        if (SeedRegistry.isEmpty()) {
            list.add(Utils.getInvalidSeed(this));
        }
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        for (CompatibilitySeed compatSeed : CompatibilitySeed.values()) {
            if (!Loader.isModLoaded((String)compatSeed.getModid()) || !compatSeed.getConfig()) continue;
            stack = compatSeed.onRightClick(stack, world, player);
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public String getItemStackDisplayName(ItemStack stack) {
        if (Utils.isValidSeed(Utils.getItemDamage(stack))) {
            return String.format(StatCollector.translateToLocal((String)this.getUnlocalizedName()), StatCollector.translateToLocal((String)SeedRegistry.getSeed(Utils.getItemDamage(stack)).getName()));
        }
        return String.format(StatCollector.translateToLocal((String)this.getUnlocalizedName()), StatCollector.translateToLocal((String)"info.ResourcefulCrops.broken"));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        if (!Utils.isValidSeed(Utils.getItemDamage(stack))) {
            list.add(EnumChatFormatting.RED + StatCollector.translateToLocal((String)"info.ResourcefulCrops.warn"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int pass) {
        if (pass == 1 && Utils.isValidSeed(stack.getItemDamage())) {
            return SeedRegistry.getSeed(Utils.getItemDamage(stack)).getColor().getRGB();
        }
        return super.getColorFromItemStack(stack, pass);
    }

    public int getRenderPasses(int metadata) {
        return this.requiresMultipleRenderPasses() ? 2 : 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }
}

