/*
 * Decompiled with CFR 0.152.
 */
package tehnut.resourceful.crops.compat.bloodmagic;

import WayofTime.alchemicalWizardry.api.harvest.IHarvestHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import tehnut.resourceful.crops.api.registry.SeedRegistry;
import tehnut.resourceful.crops.api.util.BlockStack;
import tehnut.resourceful.crops.block.BlockRCrop;
import tehnut.resourceful.crops.registry.ItemRegistry;
import tehnut.resourceful.crops.tile.TileRCrop;
import tehnut.resourceful.crops.util.Utils;

public class ResourcefulCropsHarvestHandler
implements IHarvestHandler {
    public boolean harvestAndPlant(World world, int x, int y, int z, Block block, int meta) {
        TileEntity cropTile;
        if (block instanceof BlockRCrop && (cropTile = world.getTileEntity(x, y, z)) != null && cropTile instanceof TileRCrop && meta == 7) {
            world.setBlockMetadataWithNotify(x, y, z, 0, 3);
            Utils.playBlockBreakAnim(world, x, y, z, new BlockStack(block, world.getBlockMetadata(x, y, z)));
            ItemStack seedStack = new ItemStack(ItemRegistry.shard, 1, SeedRegistry.getIndexOf(((TileRCrop)cropTile).getSeedName()));
            this.dropItem(world, x, y, z, seedStack);
            return true;
        }
        return false;
    }

    private void dropItem(World world, int x, int y, int z, ItemStack stack) {
        if (!world.isRemote && !world.restoringBlockSnapshots) {
            float f = 0.7f;
            double xOff = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double yOff = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double zOff = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + xOff, (double)y + yOff, (double)z + zOff, stack);
            entityitem.delayBeforeCanPickup = 10;
            world.spawnEntityInWorld((Entity)entityitem);
        }
    }
}

