/*
 * Decompiled with CFR 0.152.
 */
package tehnut.resourceful.crops.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import tehnut.resourceful.crops.ConfigHandler;
import tehnut.resourceful.crops.ResourcefulCrops;
import tehnut.resourceful.crops.api.ModInformation;
import tehnut.resourceful.crops.registry.BlockRegistry;
import tehnut.resourceful.crops.registry.ItemRegistry;

public class BlockROre
extends Block {
    public IIcon[] icons = new IIcon[2];
    Random random = new Random();

    public BlockROre() {
        super(Material.rock);
        this.setBlockName("ResourcefulCrops.ore");
        this.setCreativeTab(ResourcefulCrops.tabResourcefulCrops);
        this.setStepSound(soundTypeStone);
        this.setHardness(4.0f);
        this.setHarvestLevel("pickaxe", 3);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.icons[0] = iconRegister.registerIcon(ModInformation.TEXLOC + "oreGaianite");
        this.icons[1] = iconRegister.registerIcon(ModInformation.TEXLOC + "oreGaianite_nether");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return this.icons[meta];
    }

    public void harvestBlock(World world, EntityPlayer player, int x, int y, int z, int meta) {
        if (player instanceof FakePlayer && !ConfigHandler.enableFakePlayerMining) {
            Block blockItem = Blocks.cobblestone;
            BlockROre.dropItem(world, x, y, z, new ItemStack(blockItem, 1, 0));
        } else {
            boolean silk = EnchantmentHelper.getSilkTouchModifier((EntityLivingBase)player);
            if (silk) {
                Block ore = BlockRegistry.ore;
                BlockROre.dropItem(world, x, y, z, new ItemStack(ore, 1, meta));
            } else {
                int dropAmount;
                int fortune = EnchantmentHelper.getFortuneModifier((EntityLivingBase)player);
                if (fortune > 0) {
                    int bonus = this.random.nextInt(fortune + 2) - 1;
                    if (bonus < 0) {
                        bonus = 0;
                    }
                    dropAmount = bonus + 1;
                } else {
                    dropAmount = 1;
                }
                Item droppedItem = ItemRegistry.material;
                BlockROre.dropItem(world, x, y, z, new ItemStack(droppedItem, dropAmount, 0));
            }
        }
    }

    public static EntityItem dropItem(World world, double x, double y, double z, ItemStack stack) {
        if (stack == null) {
            return null;
        }
        EntityItem entityItem = new EntityItem(world, x, y, z, stack.copy());
        entityItem.delayBeforeCanPickup = 10;
        if (!world.isRemote && world.getGameRules().getGameRuleBooleanValue("doTileDrops") && !world.restoringBlockSnapshots) {
            world.spawnEntityInWorld((Entity)entityItem);
        }
        return entityItem;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 2; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    protected boolean canSilkHarvest() {
        return true;
    }

    public Item getItemDropped(int damage, Random random, int fortune) {
        return ItemRegistry.material;
    }

    public int quantityDroppedWithBonus(int fortune, Random random) {
        if (fortune > 0) {
            int bonus = random.nextInt(fortune + 2) - 1;
            if (bonus < 0) {
                bonus = 0;
            }
            return this.quantityDropped(random) * (bonus + 1);
        }
        return 1;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.rand);
        for (int i = 0; i < count; ++i) {
            Item item = this.getItemDropped(metadata, world.rand, fortune);
            if (item == null || !ConfigHandler.enableFakePlayerMining) continue;
            ret.add(new ItemStack(item, 1, this.damageDropped(metadata)));
        }
        return ret;
    }

    public int getExpDrop(IBlockAccess world, int meta, int fortune) {
        return MathHelper.getRandomIntegerInRange((Random)this.random, (int)3, (int)7);
    }
}

