/*
 * Decompiled with CFR 0.152.
 */
package tehnut.resourceful.crops.util.serialization.serializers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import tehnut.resourceful.crops.api.base.Chance;
import tehnut.resourceful.crops.api.base.ChanceBuilder;
import tehnut.resourceful.crops.util.helper.JsonHelper;

public class CustomChanceJson
implements JsonDeserializer<Chance>,
JsonSerializer<Chance> {
    public Chance deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonHelper helper = new JsonHelper(json);
        double extraSeed = helper.getNullableDouble("extraSeed", 0.0);
        double essenceDrop = helper.getNullableDouble("essenceDrop", 0.0);
        ChanceBuilder builder = new ChanceBuilder();
        builder.setExtraSeed(extraSeed);
        builder.setEssenceDrop(essenceDrop);
        return builder.build();
    }

    public JsonElement serialize(Chance src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("extraSeed", (Number)src.getExtraSeed());
        jsonObject.addProperty("essenceDrop", (Number)src.getEssenceDrop());
        return jsonObject;
    }
}

