/*
 * Decompiled with CFR 0.152.
 */
package tehnut.resourceful.crops.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import tehnut.resourceful.crops.ResourcefulCrops;
import tehnut.resourceful.crops.api.ModInformation;
import tehnut.resourceful.crops.api.base.Seed;
import tehnut.resourceful.crops.api.registry.SeedRegistry;
import tehnut.resourceful.crops.registry.BlockRegistry;
import tehnut.resourceful.crops.tile.TileRCrop;
import tehnut.resourceful.crops.util.Utils;

public class ItemSeed
extends Item
implements IPlantable {
    public ItemSeed() {
        this.func_77655_b("ResourcefulCrops.seed");
        this.func_111206_d(ModInformation.TEXLOC + "seed_base");
        this.func_77637_a(ResourcefulCrops.tabResourcefulCrops);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        for (Seed seed : SeedRegistry.getSeedList()) {
            list.add(new ItemStack((Item)this, 1, SeedRegistry.getIndexOf(seed)));
        }
        if (SeedRegistry.isEmpty()) {
            list.add(Utils.getInvalidSeed(this));
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Seed seed;
        Block placed = world.func_147439_a(x, y, z);
        if (this.isSoil(world, x, y, z, placed, seed = SeedRegistry.getSeed(Utils.getItemDamage(stack))) && ForgeDirection.getOrientation((int)side) == ForgeDirection.UP && Utils.isValidSeed(Utils.getItemDamage(stack)) && world.func_147437_c(x, y + 1, z)) {
            world.func_147449_b(x, y + 1, z, BlockRegistry.crop);
            ((TileRCrop)world.func_147438_o(x, y + 1, z)).setSeedName(seed.getName());
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
            }
            return true;
        }
        return false;
    }

    public boolean isSoil(World world, int x, int y, int z, Block block, Seed seed) {
        return !seed.getNether() && block.canSustainPlant((IBlockAccess)world, x, y, z, ForgeDirection.UP, (IPlantable)this) || seed.getNether() && world.func_147439_a(x, y, z) == Blocks.field_150425_aM;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        if (Utils.isValidSeed(Utils.getItemDamage(stack))) {
            return String.format(StatCollector.func_74838_a((String)this.func_77658_a()), StatCollector.func_74838_a((String)SeedRegistry.getSeed(Utils.getItemDamage(stack)).getName()));
        }
        return String.format(StatCollector.func_74838_a((String)this.func_77658_a()), StatCollector.func_74838_a((String)"info.ResourcefulCrops.dead"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        if (!Utils.isValidSeed(Utils.getItemDamage(stack))) {
            list.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"info.ResourcefulCrops.warn"));
        } else {
            list.add(String.format(StatCollector.func_74838_a((String)"info.ResourcefulCrops.tier"), SeedRegistry.getSeed(Utils.getItemDamage(stack)).getTier()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        if (pass == 1 && Utils.isValidSeed(Utils.getItemDamage(stack))) {
            return SeedRegistry.getSeed(Utils.getItemDamage(stack)).getColor().getRGB();
        }
        return super.func_82790_a(stack, pass);
    }

    public int getRenderPasses(int metadata) {
        return this.func_77623_v() ? 2 : 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Crop;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return BlockRegistry.crop;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return 0;
    }
}

