/*
 * Decompiled with CFR 0.152.
 */
package tehnut.resourceful.crops.compat.enderio;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.enderio.machine.farm.farmers.PlantableFarmer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import tehnut.resourceful.crops.ConfigHandler;
import tehnut.resourceful.crops.block.BlockRCrop;
import tehnut.resourceful.crops.item.ItemSeed;
import tehnut.resourceful.crops.registry.ItemRegistry;
import tehnut.resourceful.crops.util.Utils;

public class ResourcefulCropsFarmer
extends PlantableFarmer {
    public boolean canHarvest(TileFarmStation farmStation, BlockCoord coord, Block block, int meta) {
        return ConfigHandler.enableEnderIOAutomation && block instanceof BlockRCrop && farmStation.func_145831_w().func_72805_g(coord.x, coord.y, coord.z) == 7;
    }

    public boolean canPlant(ItemStack stack) {
        return ConfigHandler.enableEnderIOAutomation && stack != null && stack.func_77973_b() instanceof ItemSeed && Utils.getItemDamage(stack) != Short.MAX_VALUE;
    }

    public boolean prepareBlock(TileFarmStation farmStation, BlockCoord coord, Block block, int meta) {
        Item seed;
        if (block == null) {
            return false;
        }
        ItemStack seedStack = farmStation.getSeedTypeInSuppliesFor(coord);
        if (seedStack == null) {
            return false;
        }
        if (!this.canPlant(seedStack)) {
            return false;
        }
        if (!farmStation.hasHoe()) {
            return false;
        }
        Block plantOn = farmStation.getBlock(coord.getLocation(ForgeDirection.DOWN));
        if (!(block.canSustainPlant((IBlockAccess)farmStation.func_145831_w(), coord.x, coord.y, coord.z, ForgeDirection.UP, (IPlantable)ItemRegistry.seed) || plantOn != Blocks.field_150346_d && plantOn != Blocks.field_150349_c)) {
            farmStation.func_145831_w().func_147449_b(coord.x, coord.y - 1, coord.z, Blocks.field_150458_ak);
            farmStation.damageHoe(1, coord);
        }
        if ((seed = seedStack.func_77973_b()).func_77648_a(seedStack, (EntityPlayer)farmStation.getFakePlayer(), farmStation.func_145831_w(), coord.x, coord.y - 1, coord.z, 1, 0.5f, 0.5f, 0.5f)) {
            farmStation.takeSeedFromSupplies(coord);
        }
        return false;
    }

    public IHarvestResult harvestBlock(TileFarmStation farmStation, BlockCoord coord, Block block, int meta) {
        if (!(this.canHarvest(farmStation, coord, block, meta) && farmStation.hasHoe() && block instanceof BlockRCrop)) {
            return null;
        }
        List<ItemStack> dropped = ((BlockRCrop)block).getDrops(farmStation.func_145831_w(), coord.x, coord.y, coord.z, meta);
        BlockRCrop.setShouldDrop(false);
        farmStation.func_145831_w().func_147468_f(coord.x, coord.y, coord.z);
        BlockRCrop.setShouldDrop(true);
        return new HarvestResult(this.getEntities(farmStation.func_145831_w(), coord, dropped), coord);
    }

    private List<EntityItem> getEntities(World world, BlockCoord bc, List<ItemStack> dropped) {
        ArrayList<EntityItem> entities = new ArrayList<EntityItem>(dropped.size());
        for (ItemStack stack : dropped) {
            entities.add(new EntityItem(world, (double)bc.x + 0.5, (double)bc.y + 0.2, (double)bc.z + 0.5, stack));
        }
        return entities;
    }
}

